import numpy as np
import matplotlib.pyplot as plt
if __name__ == '__main__':
    a = np.load('est_val_compare_reps_100.npy')
    n_params = len(a[1,:])
    param_idx = np.arange(1,len(a[1,:])+1)
    plt.rcParams["figure.figsize"] = (6.5,4.5)
    plt.rcParams.update({'font.size': 18})
    plt.rcParams['font.family'] = 'serif'
    plt.tick_params(axis='both', which='major', labelsize=16)
    plt.rc('legend',fontsize=13)
    #plt.xscale('log', base=10)
    #plt.yscale('log', base=2)
    #plt.grid(True, which="both", linestyle='--', linewidth=0.5)
    #plt.scatter(param_idx,a[0], c='tab:blue')
    #plt.scatter(param_idx,a[2], c='tab:orange')
    plt.plot(param_idx,a[0,:],linewidth = 3, c='tab:blue',label = 'Generator Gradient')
    ci1 = np.array([a[0,:]+a[1,:]*1.96, a[0,:]-a[1,:]*1.96])
    plt.fill_between(param_idx, ci1[0,:], ci1[1,:], color='tab:blue', alpha=0.3,
                 label='95% CI')
    
    plt.plot(param_idx,a[2], linewidth = 1.5,c='tab:orange',label = 'Pathwise Differentiation')
    ci2 = np.array([a[2,:]+a[3,:]*1.96, a[2,:]-a[3,:]*1.96])
    plt.fill_between(param_idx, ci2[0,:], ci2[1,:], color='tab:orange', alpha=0.3,
                 label='95% CI')
    plt.xlabel("Coordinate index of θ")
    plt.ylabel("Estimated value")
    plt.legend(loc='upper left')
    plt.tight_layout()
    plt.savefig('val_est_err', dpi=800)