export WANDB_PROJECT=YOUR_PROJECT_NAME
export WANDB_ENTITY=YOUR_WANDB_ENTITY
export WANDB_API_KEY=YOUR_WANDB_API_KEY

export NUMBER_OF_GPUS=4
export MODEL_SIZE=60
export MODEL_SUFFIX=$1
export MODEL_NAME=tinyllama'_'$MODEL_SIZE'M_'$MODEL_SUFFIX
export WANDB_NAME=$MODEL_NAME

lightning run model \
    --node-rank=0  \
    --main-address=127.0.0.1 \
    --accelerator=cuda \
    --num-nodes=1 \
    --devices=$NUMBER_OF_GPUS \
    pretrain/tinyllama_downsample_kv_bias.py --devices $NUMBER_OF_GPUS \
    --train_data_dir lit_dataset_regmix \
    --val_data_dir lit_dataset_regmix \
    --data_yaml_file configs/kv_bias/tinyllama_$MODEL_SIZE'm_'$MODEL_SUFFIX.yaml \
    --out_name $MODEL_NAME \
    --resume True \
    --downsample_ratio 1.0
