import os
import sys

import re
import ast
import json

def load_json(path, index):
  start, end = None, None
  if index != "-1":
    parts = index.split('-')
    if len(parts) == 1:
      point = int(parts[0])
      start, end = point, point+1
    else:
      start, end = int(parts[0]), int(parts[1])
    print(f"Start: {start}, End: {end}")

  if os.path.isdir(path):
    data = []
    
    if start is None or end is None:
      files = [x for x in os.listdir(path) if x.endswith('.json')]
      start, end = 0, len(files)
      print(f"Start: {start}, End: {end}")

    for i in range(start, end):
      file = os.path.join(path, f'{i}.json')
      data.append(json.load(open(file)))

    return data, start, end
  
  else:

    if path.endswith('jsonl'):
      data = [json.loads(x) for x in open(path)]
    else:
      data = json.load(open(path))
      
    if start is None or end is None:
      start, end = 0, len(data)
      print(f"Start: {start}, End: {end}")
    return data[start:end], start, end
  



def get_valid_entry(content):
  try:
    valid_entry = ast.literal_eval('[' + content +']')
  except:
    key_value_pattern = r'([^:]+):(("[^"]+")|([^,]+)),?'
    
    valid_entry = {}
    for x in re.findall(key_value_pattern, content):
      key = x[0].strip().lstrip('{')
      value = x[1].strip().rstrip(';').rstrip('}')
      xx = '{' + key + ':' + value + '}'
      try:
        xx = ast.literal_eval(xx)
        if isinstance(xx, dict):
          valid_entry.update(xx)
      except:
        continue
  return valid_entry


def check_json(response):
  response = response.replace('\n', '')
  # response = response.replace("{{", "{").replace("}}", "}")
  response = response.replace("  ", "")
  code_env = r'```([\s\S]*?)```'
  match_content = re.findall(code_env, response)
  if match_content != []:
    # response = match_content.group(1).lstrip('json').lstrip('css').lstrip('javascript').lstrip('vbnet')
    response = match_content[-1].lstrip('json').lstrip('css').lstrip('javascript').lstrip('vbnet')
  else:
    json_env = r'({([\s\S]*?)}+)'
    match_content = re.findall(json_env, response)
    if match_content  != []:
      # response = match_content.group(1)
      response = match_content[-1][0]


  try:
    content = ast.literal_eval(response)
    response = json.dumps(content)
  except:
    repaired_response = response
    json_env = r'{([\s\S]*?)}'
    inner_content = response.strip()[1:-1]
    for x in re.findall(json_env, inner_content):
      xx = x.strip()
      valid_entries = get_valid_entry(xx)
      valid_str = json.dumps(valid_entries)
      repaired_response = response.replace('{'+x+'}', valid_str)
    response = repaired_response
  
  try:
    content = json.loads(response)
  except:
    return False, None

  return True, content