#!/bin/bash
set -e

echo "🚀 Running evaluation"
# Configuration

# ADD IMAGE_FACTOR as enviroment variables
export VIDEOENV_IMAGE_FACTOR=28
echo "  * VIDEOENV_IMAGE_FACTOR: $VIDEOENV_IMAGE_FACTOR"


MODEL_PATH=""
EXPERIMENT_BASE_NAME="eval"


DATASETS=("mlvu_test" "egoschema_500" "videomme_long" "videomme_medium" "videomme_short")

# Ensure we're in the right directory
cd /data/xieyuan

# Set environment variables for proper evaluation


echo "📂 Model path: $MODEL_PATH"
echo "🏷️ Eval experiment name: $EXPERIMENT_BASE_NAME"
echo "📊 Datasets: ${DATASETS[@]}"

# Run the evaluation using real training components
CUDA_VISIBLE_DEVICES=0,1,2,3 python3 -m VAGEN.vagen.eval.eval_bench_video_env \
    --model_path "$MODEL_PATH" \
    --file_name "if$VIDEOENV_IMAGE_FACTOR" \
    --datasets "${DATASETS[@]}" \
    --prefix $EXPERIMENT_BASE_NAME \
    --eval_fresh \



echo "✅ Evaluation completed! Check the results in ./results/ directory"
echo "📄 Full log saved to eval_training_components.log" 
