import pandas as pd
import wandb

api = wandb.Api()

# Project is specified by <entity/project-name>
runs = api.runs("gauravmm/bigsweep1--PopTD_CQL")
series = []

blacklist_runs = [
    "",
]
for run in runs:

    history = list(
        run.scan_history(keys=["average_return", "epoch"])
    )
    try:
        last = history[-1]
    except IndexError:
        continue
    rets = last["average_return"]
    if (run.config['seed'] - 0xCAFE0000) >= 8:
        continue
    if run.config['cql.use_pop']:
        print("WAIT, THERE SHOULDN'T BE ANY POP RUNS HERE")
        assert False
    print(f"{run.config['env']}\t{run.config['seed']:X}\t{run.config['cql.use_pop']}\t{rets:04f}")

    df = pd.DataFrame(
        {
            "average_return": rets,
            "run": run.name,
            "seed": run.config["seed"],
            "env": run.config["env"],
        }, index=[run.name]
    )
    series.append(df)

pd.concat(series, axis=0, ignore_index=True).to_csv("dump.csv")
