import pandas as pd
import wandb

api = wandb.Api()

# Project is specified by <entity/project-name>
# runs = api.runs("gauravmm/popcql_final_1--PopTD_CQL")
runs = api.runs("gauravmm/dualdice_cql--PopTD_CQL")
series = []

blacklist_runs = [
    "",
]
for run in runs:

    history = list(
        run.scan_history(keys=["average_return", "A1_min_eig", "A2_min_eig", "epoch"])
    )
    last = history[-1]
    rets = last["average_return"]
    eig = min(last["A1_min_eig"], last["A2_min_eig"])
    print(f"{run.name} : {rets:04f}")

    df = pd.DataFrame(
        {
            "average_return": rets,
            "run": run.name,
            "seed": run.config["seed"],
            "env": run.config["env"],
        }, index=[run.name]
    )
    series.append(df)

pd.concat(series, axis=0, ignore_index=True).to_csv("dump.csv")
