# Optimal ANN-SNN Conversion for High-accuracy and Ultra-low-latency Spiking Neural Networks
This directory contains the code of this paper.
## Dependency
The major dependencies of this code are list as below. 
```
torch==1.7.1
tqdm==4.55.0
numpy==1.18.5
torchvision==0.8.2
Pillow==8.3.2
```
## Environment
* System: Ubuntu 20.04.1 LTS (GNU/Linux 4.19.128-microsoft-standard x86_64)
* GPU: GPU: Tesla *V100-SXM2-32GB* 300 Watts version
* CPU: Intel(R) Xeon(R) Platinum 8268 CPU @ 2.90GHz

## Usage
Get info
```python
python train.py --help
python test.py --help
```

Train a VGG-16 model on CIFAR-10 dataset
```python
python train.py --arch vgg16 --dataset CIFAR10
```

Test the pre-trained ANN at 32 time steps
```python
python test.py --dataset CIFAR10 --T 32
```

