import json
import os.path as osp
from LabanCalculate import xyz2laban
from tqdm import tqdm

def main():
    split = 'evaluation'
    root_dir_path = osp.dirname(osp.dirname(osp.dirname(osp.abspath(__file__))))
    json_name = split + '_xyz.json'
    laban_name = split + '_laban.json'
    json_file = osp.join(root_dir_path, 'freihand_data', json_name)
    laban_path = osp.join(root_dir_path, 'freihand_data', laban_name)
    f = open(json_file, 'r')
    xyz_data = json.load(f)
    laban_res_list = []
    for i in tqdm(range(len(xyz_data))):
        laban_res = xyz2laban(xyz_data[i])
        laban_res_list.append(laban_res.copy())
    with open(laban_path, 'w') as json_file:
        json.dump(laban_res_list, json_file)
    
if __name__ == '__main__':
    main()