import json
import os.path as osp
from tqdm import tqdm

def main():
    split = 'val'
    root_dir_path = osp.dirname(osp.dirname(osp.dirname(osp.abspath(__file__))))
    data_dir = osp.join(root_dir_path,'data')
    img_dir = osp.join(data_dir, 'images')
    split_img_dir = osp.join(img_dir, split)
    annotation_dir = osp.join(data_dir, 'annotations')
    split_annotation_dir = osp.join(annotation_dir, split)
    data_file_name = 'InterHand2.6M_' + split + '_data.json' 
    img2frame_file_name = 'InterHand2.6M_' + split + '_img2frame.json'
    img2frame_path = osp.join(split_annotation_dir, img2frame_file_name)
    data_file_path = osp.join(split_annotation_dir, data_file_name)
    f = open(data_file_path, 'r')
    data = json.load(f)
    img2frame_dict = {}
    # value_ans = {}
    for i in tqdm(range(len(data['images']))):
        if data['images'][i]['file_name'] == 'Capture0/0004_star_trek/cam400010/image1575.jpg':
            print('bingo')
        temp = data['images'][i]['file_name']
        value_ans = {}
        file_name = data['images'][i]['file_name']
        file_name_comp = osp.join(split_img_dir,file_name)
        # file_name_comp = str.replace(file_name_comp, '/','\\')
        # file_name_comp = str.replace(file_name_comp, '\\','\\')
        capture_id = data['images'][i]['capture']
        frame_id = data['images'][i]['frame_idx']
        hand_type = data['annotations'][i]['hand_type']
        capture_id_str = str(capture_id)
        frame_id_str = str(frame_id)
        value_ans['capture_id'] = capture_id_str
        value_ans['frame_idx'] = frame_id_str
        value_ans['hand_type'] = hand_type
        img2frame_dict[file_name_comp] = value_ans
        
    with open(img2frame_path, 'w') as json_file:
        json.dump(img2frame_dict, json_file)

if __name__ == '__main__':
    main()
        
        
    