## Few-shot 3D Shape Generation
We explore few-shot 3D shape generation tasks. Our approach is implemented based on GET3D (NVIDIA, 2022).
GET3D url: https://github.com/nv-tlabs/GET3D

## Requirements
* We carry out experiments in Linux systems.
* We have done all the experiments and testing on NVIDIA A40 GPUs (45GB memory of each). 
* Python 3.8 and PyTorch 1.9.0. 
* CUDA toolkit 11.1 or later.
* Nvdiffrast 
* tensorboard
* pytorch_fid
* setuptools == 59.5.0
* Other requirements are listed in install_get3d.sh

## Preparing datasets

We follow GET3D to use ShapeNetCore datasets. The download and rendering methods for ShapeNetCore datasets are provided in ./render_shapenet_data.  

## Train the model

- Adapt pre-trained source models to target domains using limited data (e.g., 10 shapes used in our experiments).

Setup A: loss_A.py --> loss.py, only the silhouettes are needed as training data.
Setup B: loss_B.py --> loss.py, both the rgb images and silhouettes are needed as trainig data.

#### Training using the source model pre-trained on ShapeNetCore Cars
python train_3d.py --outdir=PATH_TO_LOG --data=PATH_TO_RENDER_IMG --camera_path PATH_TO_RENDER_CAMERA --gpus=1 --batch=4 --gamma=40 --data_camera_mode shapenet_car  --dmtet_scale 1.0  --use_shapenet_split 0  --one_3d_generator 1  --fp32 0 --resume_pretrain PATH_TO_PRETRAINED_CHECKPOINT

#### Training using the source model pre-trained on ShapeNetCore Chairs
python train_3d.py --outdir=PATH_TO_LOG --data=PATH_TO_RENDER_IMG --camera_path PATH_TO_RENDER_CAMERA --gpus=1 --batch=4 --gamma=400 --data_camera_mode shapenet_chair  --dmtet_scale 0.8  --use_shapenet_split 0  --one_3d_generator 1  --fp32 0 --resume_pretrain PATH_TO_PRETRAINED_CHECKPOINT

## Inference
### Inference on adapted models for visualization

### 3D inference: generate 3D textured meshes with *.obj, *.mtl, *.png files. 

#### Inference 3D shapes of adapted cars
python train_3d.py --outdir=save_inference_results/cars_3d  --gpus=1 --batch=4 --gamma=40 --data_camera_mode shapenet_car  --dmtet_scale 1.0  --use_shapenet_split 1  --one_3d_generator 1  --inference_to_generate_textured_mesh 1 --fp32 0 --inference_vis 1 --resume_pretrain MODEL_PATH 

#### Inference 3D shapes of adapted chairs
python train_3d.py --outdir=save_inference_results/chairs_3d  --gpus=1 --batch=4 --gamma=40 --data_camera_mode shapenet_chair  --dmtet_scale 0.8  --use_shapenet_split 1  --one_3d_generator 1  --inference_to_generate_textured_mesh 1 --fp32 0 --inference_vis 1 --resume_pretrain MODEL_PATH

### 2D inference: generate multi-view 2D RGB images and silhouettes of generated shapes (png format).

#### Inference 2D shapes of adapted cars
python train_3d.py --outdir=save_inference_results/cars_2d --inference_2d True --gpus=1 --batch=4 --gamma=40 --data_camera_mode shapenet_car  --dmtet_scale 1.0  --use_shapenet_split 0  --one_3d_generator 1  --fp32 0 --resume_pretrain MODEL_PATH

#### Inference 2D shapes of adapted chairs
python train_3d.py --outdir=save_inference_results/chairs_2d --inference_2d True --gpus=1 --batch=4 --gamma=40 --data_camera_mode shapenet_chair  --dmtet_scale 0.8  --use_shapenet_split 0  --one_3d_generator 1  --fp32 0 --resume_pretrain MODEL_PATH

### Evluation metrics

##### Generation Quality
We use chamfer distance to evaluate the learning of target geometry distributions:

# For cars evaluation, use npz format files
python eval_cd.py --eval_cd True --gen_path PATH_TO_GENERATED_SHAPES --train_data_path ABUNDANT_TARGET_SHAPES --use_npz True

# For chairs evaluation, use obj format files
python eval_cd.py --eval_cd True --gen_path PATH_TO_GENERATED_SHAPES --train_data_path ABUNDANT_TARGET_SHAPES 

#### Generation Diversity
We use pairwise- and intra- formats of chamfer distance and LPIPS to evaluate the diversity of adapted models.

# For cars evaluation, use npz format files
python eval_cd.py --eval_cd True --gen_path PATH_TO_GENERATED_SHAPES --train_data_path TRAINING_TARGET_SHAPES --gen_images_path PATH_TO_RENDERED_IMAGES_OF_GENERATED_SHAPES --train_images_path PATH_TO_RENDERED_IMAGES_OF_TRAINING_TARGET_SHAPES --use_npz True

# For chairs evaluation, use obj format files
python eval_cd.py --eval_cd True --gen_path PATH_TO_GENERATED_SHAPES --train_data_path ABUNDANT_TARGET_SHAPES --gen_images_path PATH_TO_RENDERED_IMAGES_OF_GENERATED_SHAPES --train_images_path PATH_TO_RENDERED_IMAGES_OF_TRAINING_TARGET_SHAPES

