## Expressivity demo 

Fan dataset

```bash
python main.py --data fan --epoch 10000 --init 0.01 --loss logistic --lr 0.2
python main.py --data fan --epoch 10000 --init 0.01 --loss logistic --lr 0.2 --bias
python main.py --data fan --epoch 80000 --init 0.01 --depth 3 --loss logistic --lr 0.2
python main.py --data fan --epoch 80000 --init 0.01 --depth 3 --loss logistic --lr 0.2 --bias
```

Circle dataset

```bash
python main.py --data circle --epoch 10000 --init 0.01 --loss logistic --lr 0.2 --dataset_size 120
python main.py --data circle --epoch 10000 --init 0.01 --loss logistic --lr 0.2 --bias --dataset_size 120
python main.py --data circle --epoch 80000 --init 0.01 --depth 3 --loss logistic --lr 0.2 --dataset_size 120
python main.py --data circle --epoch 80000 --init 0.01 --depth 3 --loss logistic --lr 0.2 --bias --dataset_size 120
```


## Two-layer Network Dynamics

Symmetric dataset
```bash
python main.py --data multi --sweep leaky_sweep --track_weight --init 1e-8 --hid 500 --epoch 2000 --lr 0.04  # quick debug run
python main.py --data multi --sweep leaky_sweep --init 1e-8 --hid 500 --epoch 10000 --lr 0.004 --track_weight
python main.py --data multi --sweep compare --init 1e-8 --hid 500 --epoch 10000 --lr 0.004 --track_weight
```

Symmetric dataset with regularization. Just add `--reg 0.2 -- epoch 15000` to the commands above.

Orthogonal and XOR
```bash
python xor.py --init 1e-6 --lr 0.001 --epoch 20000 --track_weight --hid 60
python xor.py --init 1e-6 --lr 0.004 --epoch 20000 --track_weight --hid 60 --loss logistic
```


## Deep ReLU Network Dynamics
```
python main.py --data multi --depth 3 --epoch 20001  --lr 0.1 --hid 100 --track_weight --relu 0
```


## Perturbed Symmetric Dataset
```bash
python main.py  --epoch 40000 --init 0.001 --lr 0.025
python main.py  --epoch 60000 --init 0.001 --lr 0.04 --loss logistic
```