# Implement output perturbation for regularized logistic regresssion model
from utils import *
from gauss_mechanism import *
def output_pertb_lr(x_train, y_train, Lambda, epsilon, delta = 1e-5):
    """
    
    :param x_train: training inputs data of shape nx(d+1), where the constant bias =1 was already append to x_train 
    :param y_train: training output of shape nx1
    :param Lambda: regularization parameter, ie Lambda ||f||
    :param epsilon: privacy budget
    :return: f_priv private weight paramter
    """
    n_train = len(x_train)
    C = 1 / Lambda
    logreg = LogisticRegression(penalty='l2', C=C, fit_intercept=False)
    logreg.fit(x_train, y_train)
    f_non_priv = logreg.coef_[0]
    GS = 2 / (n_train * Lambda)  # global sensitivity  see page 10 or (1078) of https://www.jmlr.org/papers/volume12/chaudhuri11a/chaudhuri11a.pdf
    sigma = calibrateAnalyticGaussianMechanism(epsilon, delta, GS, tol=1.e-12)
    f_priv = f_non_priv + np.random.normal(0, sigma, len(f_non_priv))

    return f_priv



