export CUDA_VISIBLE_DEVICES="0,1,2,3"
####################################################################################################
# GSM8K
####################################################################################################

# after training, run this script to evaluate the model
# export model='model_checkpoint_path'
# export outdir='stage2_gsm8k_ours_120k'
# python eval_gsm8k.py --model ${model} --data_file ./data/test/GSM8K_test.jsonl --outdir ${outdir} --tensor_parallel_size 4 --seq_len 4098

# after evaluation, run this script to parse the results
# we already have the results in ./stage2_gsm8k_ours_120k.csv
export model='stage2_gsm8k_ours_120k'
export data_file='./stage2_gsm8k_ours_120k.csv'
python data_parsing_math.py --model ${model} --data_file ${data_file} --tensor_parallel_size 4

####################################################################################################
# Medical
####################################################################################################
# after training, run this script to evaluate the model
# export model='model_checkpoint_path'
# export outdir='stage2_med_ours_120k'
# python eval_medqa.py --model ${model} --data_file ./data/test/MEDQA_test_rev.jsonl --seq_len 4098 --outdir ${outdir} --tensor_parallel_size 4

# after evaluation, run this script to parse the results
# we already have the results in ./stage2_med_ours_120k.csv
export model='stage2_med_ours_120k'   
export data_file='./stage2_med_ours_120k.csv'
python data_parsing_med.py --model ${model} --data_file ${data_file} --tensor_parallel_size 4

####################################################################################################
# FinQA
####################################################################################################
# after training, run this script to evaluate the model
# export model='model_checkpoint_path'
# export outdir='stage2_finqa_ours_120k'
# python eval_finqa.py --model ${model} --data_file ./data/test/finqa_test.jsonl --outdir ${outdir} --tensor_parallel_size 4 --seq_len 4098

# after evaluation, run this script to parse the results
we already have the results in ./stage2_finqa_ours_120k.csv
export model='stage2_finqa_ours_120k'
export data_file='./stage2_finqa_ours_120k.csv'
python data_parsing_fin.py --model ${model} --data_file ${data_file} --tensor_parallel_size 4

# ####################################################################################################
# # CDSL
# ####################################################################################################
export CUDA_VISIBLE_DEVICES="0,1,2,3"
# for CDSL we upload the model on huggingface, so we can directly use the model and you can download the model from the link below
# https://huggingface.co/Anonymous0123456/PANGEA_dsl_model
export model='Anonymous0123456/PANGEA_dsl_model'
export outdir='stage2_dsl_ours_120k'
python eval_custom.py --model ${model} --data_file  data/test/custom_dsl_test_clean.json --batch_size  512 --tensor_parallel_size  2 --out_csv ${outdir}.csv --seed 777