// - = EMPTY (not walkable, not necessarily rendered)
// . = GROUND (walkable)
// | = HOLE (not walkable, blocks view)
// # = WALL (not walkable)

unsigned int map1_height = 12;
unsigned int map1_width = 12;
char map1[] =
    "............"
    ".#|..#.#|..#"
    "............"
    "..||....||.."
    "|##..#|##..#"
    "............"
    "............"
    ".#|..#.#|..#"
    "............"
    "..||....||.."
    "|##..#|##..#"
    "............";

unsigned int map2_height = 28;
unsigned int map2_width = 29;
char map2[] = 
    "-------------#.--------------"
    "-----------.#..--------------"
    "----------......-------------"
    "---------.|.#|...------------"
    "--------........#.-----------"
    "-------.............---------"
    "------...............--------"
    "------..............#.-------"
    "-----..................------"
    "---.....................-----"
    "--.|.....................----"
    "-..|......................---"
    ".................|#|.......--"
    "-#..............||||.......--"
    "--..............#|#|........."
    "---...............#.........-"
    "----.......................--"
    "-----.....................---"
    "------...................----"
    "-------.................-----"
    "--------...............------"
    "---------.............-------"
    "----------...........--------"
    "-----------.........---------"
    "------------.......----------"
    "-------------.....-----------"
    "--------------|.#------------"
    "---------------.-------------";

unsigned int map3_height = 28;
unsigned int map3_width = 29;
char map3[] = 
    "-------------#.--------------"
    "-----------.#..--------------"
    "----------.......------------"
    "---------.|.#|..#------------"
    "--------........#.-----------"
    "-------.............---------"
    "------...........#...--------"
    "------....||........#.-------"
    "-----..................------"
    "---.............##......-----"
    "--.|......#..............----"
    "-..|.....##...............---"
    "..................#|#......--"
    "-###............|..........--"
    "--..............#|#.........-"
    "---...............#.........-"
    "----......#|...............--"
    "-----.....................---"
    "------...........#|#.....----"
    "-------............#....-----"
    "--------...............------"
    "---------...##|#.......------"
    "----------...........--------"
    "-----------.........---------"
    "------------.......----------"
    "-------------.....-----------"
    "--------------..#------------"
    "---------------.-------------";

char* get_map(int map_id) {
    switch (map_id) {
        case 1: return map1; break;
        case 2: return map2; break;
        case 3: return map3; break;
        default: printf("Invalid map id <%i>\n", map_id); exit(1);
    }
}

unsigned int get_map_height(int map_id) {
    switch (map_id) {
        case 1: return map1_height; break;
        case 2: return map2_height; break;
        case 3: return map3_height; break;
        default: printf("Invalid map id <%i>\n", map_id); exit(1);
    }
}

unsigned int get_map_width(int map_id) {
    switch (map_id) {
        case 1: return map1_width; break;
        case 2: return map2_width; break;
        case 3: return map3_width; break;
        default: printf("Invalid map id <%i>\n", map_id); exit(1);
    }
}
