"""BLEU evaluator"""
from openicl.icl_evaluator import BaseEvaluator
from typing import List, Dict
import evaluate
from nltk.translate.bleu_score import corpus_bleu, SmoothingFunction
    

class BleuEvaluator(BaseEvaluator):
    def __init__(self, num_gram = 1) -> None:
        self.num_gram = num_gram
        self.smooth = False if num_gram != 4 else True
        super().__init__()

    def score(self, predictions, references):
        assert len(predictions) == len(references)
        metric = evaluate.load('bleu')
        scores = metric.compute(predictions=predictions, references=references, max_order=self.num_gram, smooth=self.smooth)
        return scores
        
    def pred_verification(self, predictions):
        empty_answer_num = 0
        for idx in range(len(predictions)):
            if len(predictions[idx]) == 0:
                predictions[idx] = ' '
                empty_answer_num += 1
            else:
                pass
        print(f'Empty answer size: {empty_answer_num / len(predictions)}')
        return predictions
