def gen_template_classification(args):
    # Setiment Classification
    if args.dataset == "sst2" or args.dataset == "gen-sst2":
        tp_dict = {
            1: "</E></text> \t It was great .",
            0: "</E></text> \t It was terrible .",
        }
    elif args.dataset == "sst5" or args.dataset == "gen-sst5":
        tp_dict = {
            4: "</E></text> \t It was great .",
            3: "</E></text> \t It was good .",
            2: "</E></text> \t It was okay .",
            1: "</E></text> \t It was bad .",
            0: "</E></text> \t It was terrible .",
        }
    elif args.dataset == "amazon" or args.dataset == "gen-amazon":
        tp_dict = {
            4: "</E></text> \t It was great .",
            3: "</E></text> \t It was good .",
            2: "</E></text> \t It was okay .",
            1: "</E></text> \t It was bad .",
            0: "</E></text> \t It was terrible .",
        }
    elif args.dataset == "yelp" or args.dataset == "gen-yelp":
        tp_dict = {
            4: "</E></text> \t It was great .",
            3: "</E></text> \t It was good .",
            2: "</E></text> \t It was okay .",
            1: "</E></text> \t It was bad .",
            0: "</E></text> \t It was terrible .",
        }
    elif args.dataset == "mr" or args.dataset == "gen-mr":
        tp_dict = {
            0: "</E></text> \t It was terrible .",
            1: "</E></text> \t It was great .",
        }
    elif args.dataset == "cr" or args.dataset == "gen-cr":
        tp_dict = {
            0: "</E></text> \t It was terrible .",
            1: "</E></text> \t It was great .",
        }
    # Topic Classification
    elif args.dataset == "agnews" or args.dataset == "gen-agnews":
        tp_dict = {
            3: "</E></text> \t Topic: Technology .",
            2: "</E></text> \t Topic: Business .",
            1: "</E></text> \t Topic: Sports .",
            0: "</E></text> \t Topic: World .",
        }
    elif args.dataset == "trec" or args.dataset == "gen-agnews":
        tp_dict = {
            5: "</E></text> \t Topic: Number .",
            4: "</E></text> \t Topic: Location .",
            3: "</E></text> \t Topic: Human .",
            2: "</E></text> \t Topic: Expression .",
            1: "</E></text> \t Topic: Entity .",
            0: "</E></text> \t Topic: Description .",
        }
    elif args.dataset == "dbpedia" or args.dataset == "gen-dbpedia":
        tp_dict = {
            13: "</E></text> \t Topic: Written Work .",
            12: "</E></text> \t Topic: Film .",
            11: "</E></text> \t Topic: Albm .",
            10: "</E></text> \t Topic: Plant .",
            9: "</E></text> \t Topic: Animal .",
            8: "</E></text> \t Topic: Village .",
            7: "</E></text> \t Topic: Natural Place .",
            6: "</E></text> \t Topic: Building .",
            5: "</E></text> \t Topic: Mean of Transportation .",
            4: "</E></text> \t Topic: Office Holder .",
            3: "</E></text> \t Topic: Athlete .",
            2: "</E></text> \t Topic: Artist .",
            1: "</E></text> \t Topic: Educational Institution .",
            0: "</E></text> \t Topic: Company .",
        }
    elif args.dataset == "yahoo" or args.dataset == "gen-yahoo":
        tp_dict = {
            9: "</E></text> \t Topic: Politics & Government .",
            8: "</E></text> \t Topic: Family & Relationships .",
            7: "</E></text> \t Topic: Entertainment & Music .",
            6: "</E></text> \t Topic: Business & Finance .",
            5: "</E></text> \t Topic: Sports .",
            4: "</E></text> \t Topic: Computers & Internet .",
            3: "</E></text> \t Topic: Education & Reference .",
            2: "</E></text> \t Topic: Health .",
            1: "</E></text> \t Topic: Science & Mathematics .",
            0: "</E></text> \t Topic: Society & Culture .",
        }
    # NLI task
    elif args.dataset == "mnli" or args.dataset == "gen-mnli":
        tp_dict = {
            2: "</E></text> \t Answer: Contradiction .",
            1: "</E></text> \t Answer: Inconclusive .",
            0: "</E></text> \t Answer: Entailment .",
        }
    elif args.dataset == "snli" or args.dataset == "gen-snli":
        tp_dict = {
            2: "</E></text> \t Answer: Contradiction .",
            1: "</E></text> \t Answer: Inconclusive .",
            0: "</E></text> \t Answer: Entailment .",
        }
    elif args.dataset == "rte" or args.dataset == "gen-rte":
        tp_dict = {
            1: "</E></text> \t Answer: False .",
            0: "</E></text> \t Answer: True .",
        }
    # Subjective Classification
    elif args.dataset == "subj" or args.dataset == "gen-subj":
        tp_dict = {
            1: "</E></text> \t It's objective .",
            0: "</E></text> \t It's subjective .",
        }
    # Linguistic Acceptibility
    elif args.dataset == "cola" or args.dataset == "gen-cola":
        tp_dict = {
            1: "</E></text> \t It is grammatical .",
            0: "</E></text> \t It is not grammatical .",
        }

    else:
        raise ValueError(f"Wrong dataset name... {args.dataset}")

    return tp_dict


def gen_template_generation(args):
    # tp = "</E>Summarize the text: </text>\tTL;DR: </label>\n"
    if args.dataset == "mtop":
        tp = "</E>Parse the sentence into logical form: </text>\t</label>"
    elif args.dataset == "smcalflow":
        tp = "</E>Parse the sentence into logical form: </text>\t</label>"
    elif args.dataset == "cnn":
        tp = "</E>Summarize the text: </text>\tTL;DR: </label>"
    elif args.dataset == "pubmed":
        tp = "</E>Summarize the text: </text>\tTL;DR: </label>"
    elif args.dataset == "reddit":
        tp = "</E>Summarize the text: </text>\tTL;DR: </label>"
    elif args.dataset == "commongen":
        tp = "</E>Generate a sentence using these concepts: </text>\tGenerated sentence: </label>"
    elif args.dataset == "rocstory":
        tp = "</E>Beginning of the story: </text>\tRest of the story: </label>"
    elif args.dataset == "rocending":
        tp = "</E>An unfinished story: </text>\tEnd of the story: </label>"
    elif args.dataset == "go":
        tp = "</E>Comment on the code. Code: </text>\tComment: </label>"
    elif args.dataset == "java":
        tp = "</E>Comment on the code. Code: </text>\tComment: </label>"
    elif args.dataset == "php":
        tp = "</E>Comment on the code. Code: </text>\tComment: </label>"
    elif args.dataset == "python":
        tp = "</E>Comment on the code. Code: </text>\tComment: </label>"
    elif args.dataset == "dart":
        tp = "</E>Describe the table in natural language. Table: </text>\tSentence: </label>"
    elif args.dataset == "e2e":
        tp = "</E>Describe the table in natural language. Table: </text>\tSentence: </label>"
    else:
        raise ValueError(f"Wrong dataset name... {args.dataset}")

    return tp
