from openicl import *
from util.icl_bm25_fedretriever import BM25FedRetriever, BM25ServerRetriever
from util.icl_topk_fedretriever import TopkFedRetriever, TopkServerRetriever


def get_retriever(args):
    if args.retriever == "topk":
        return TopkRetriever
    elif args.retriever == "random":
        return RandomRetriever
    elif args.retriever == "bm25":
        return BM25Retriever
    elif args.retriever == "dpp":
        return DPPRetriever
    elif args.retriever == "mdlr":
        return MDLRRetriever
    elif args.retriever == "vote":
        return VoteRetriever
    elif args.retriever == "zero":
        return ZeroRetriever
    else:
        raise ValueError(
            f'Wrong retriever name... Please select among "{"random|topk|bm25|dpp|mdlr|vote|zero"}"... Given: {args.reriever}'
        )


def get_fedretriever(args):
    if args.retriever == "topk":
        return TopkFedRetriever
    # elif args.retriever == "random":
    #     return RandomRetriever
    elif args.retriever == "bm25":
        return BM25FedRetriever
    # elif args.retriever == "dpp":
    #     return DPPRetriever
    # elif args.retriever == "mdlr":
    #     return MDLRRetriever
    # elif args.retriever == "vote":
    #     return VoteRetriever
    # elif args.retriever == "zero":
    #     return ZeroRetriever
    else:
        raise ValueError(
            f'Wrong retriever name... Please select among "{"topk|bm25"}"... Given: {args.reriever}'
        )


def get_server_retriever(args):
    if args.retriever == "topk":
        return TopkServerRetriever
    # elif args.retriever == "random":
    #     return RandomRetriever
    elif args.retriever == "bm25":
        return BM25ServerRetriever
    # elif args.retriever == "dpp":
    #     return DPPRetriever
    # elif args.retriever == "mdlr":
    #     return MDLRRetriever
    # elif args.retriever == "vote":
    #     return VoteRetriever
    # elif args.retriever == "zero":
    #     return ZeroRetriever
    else:
        raise ValueError(
            f'Wrong retriever name... Please select among "{"topk|bm25"}"... Given: {args.reriever}'
        )
