
import cvxpy
import numpy as np


if __name__ == "__main__":
    """
    Run from root. 
    python -m scripts.test_cvxpy
    """
    # The data for the Knapsack problem
    # P is total weight capacity of sack
    # weights and utilities are also specified
    P = 165
    weights = np.array([23, 31, 29, 44, 53, 38, 63, 85, 89, 82])
    utilities = np.array([92, 57, 49, 68, 60, 43, 67, 84, 87, 72])

    # The variable we are solving for
    selection = cvxpy.Variable(len(weights), boolean=True)

    # The sum of the weights should be less than or equal to P
    weight_constraint = weights @ selection <= P

    # Our total utility is the sum of the item utilities
    total_utility = utilities @ selection

    # We tell cvxpy that we want to maximize total utility
    # subject to weight_constraint. All constraints in
    # cvxpy must be passed as a list
    knapsack_problem = cvxpy.Problem(cvxpy.Maximize(total_utility), [weight_constraint])

    # Solving the problem
    res = knapsack_problem.solve(solver=cvxpy.GLPK_MI)
    print(res)
    breakpoint()
