# Fair Dynamics Sim

An [OpenAI Gym](https://python-poetry.org/) environment for a "fair" threshold
classification task.

A population of agents is split into groups $G$.
Each agent has a real-valued feature $X$ and a binary label $Y \in \{0, 1\}$.

A classifier must predict the label from the feature, given full knowledge of
the statistics $\Pr(X | G)$ and $\Pr(Y=1 | X, G)$. Specifically, the classifier
selects a feature threshold $\theta_g$ for each group, above which features are
predicted to correspond to positive labels.

$$
\hat{Y}(x, g) = \begin{cases}
1 & x \geq \theta_g \\
0 & x < \theta_g
\end{cases}
$$

The population then evolves in response to the classifier. 
## Contents

```
.
├── poetry.lock
├── pyproject.toml
├── readme.md
├── src
│   ├── baseline_greedy.py              baseline (with greedy, gradient-descent-based agent)
│   ├── fairgym
│   │   ├── agent.py
│   │   ├── distributions               utility functions for defining random distributions
│   │   │   ├── __init__.py
│   │   │   └── sampling.py
│   │   ├── envs
│   │   │   ├── action.py
│   │   │   ├── adult
│   │   │   │   ├── __init__.py
│   │   │   │   └── preprocess.py
│   │   │   ├── base_env.py             parent class for environments with different dynamics
│   │   │   ├── default_reward.py
│   │   │   ├── __init__.py
│   │   │   ├── obs_encoding.py         how state is encoded for agent (as an image)
│   │   │   ├── replicator
│   │   │   │   ├── adult_qualification_replicator_env.py     environment subclass using replicator dynamics and "Adult" semi-synthetic data
│   │   │   │   ├── __init__.py
│   │   │   │   └── qualification_replicator_env.py           environment subclass using replicator dynamics
│   │   │   └── state.py
│   │   ├── experiment.py               record interaction of agent and environment
│   │   ├── __init__.py
│   │   ├── plotting
│   │   │   ├── __init__.py
│   │   │   ├── phase.py                function for generating phase portrait in qualification rates
│   │   │   └── video_ctx_mgr.py        utility functions for video output
│   │   └── utils
│   │       ├── logistic_regression_jax.py
│   │       ├── misc.py
│   │       └── natural_logistic_regression.py
│   └── run_all.sh
└── tests
    ├── test_jax_sanity.py
    └── test_jit_speedups.py
```

## Installation

* ffmpeg must be installed for video output
* [Poetry](https://python-poetry.org/) used for dependencies
  In this repository, run `poetry install`.

## Usage

The virtual environment created by Poetry must be activated. Use `poetry shell`
in this directory after installing the dependencies. Alternatively, you may use
something like [direnv](https://direnv.net/) to automatically activate the
correct environment when inside this repository.

See baseline_greedy.py for an example in which the population evolves according to the
replicator dynamics and the classifier is driven to maximize current accuracy
regularized by demographic parity. Qualification rate in each
group $g$ is $\Pr(Y=1 | G=g)$. Run this script with e.g. `./src/baseline_greedy.py`.
