import matplotlib.animation as animation


class Video:
    """
    Use figure to make video.
    Each frame must draw to figure, then call draw method.

    Example:

    with Video('video_name', fig) as video:
        for _ in range(num_frames):
            render()
            video.draw()
    """

    def __init__(self, title, fig, render_flag=True, fps=10):

        self.video_file = title + ".mp4"

        # whether to actually do anything
        self.render_flag = render_flag

        if render_flag:
            self.writer = animation.FFMpegWriter(
                fps=fps, metadata={"title": title, "artist": "Matplotlib"}
            )

        self.fig = fig

    def __enter__(self):
        if self.render_flag:
            # make file
            self.writer.setup(self.fig, self.video_file, dpi=100)

        return self

    def draw(self):
        if self.render_flag:
            # draw figure and clear axes
            self.writer.grab_frame()
            for ax in self.fig.axes:
                ax.cla()

    def __exit__(self, exc_type, exc_value, exc_traceback):
        if self.render_flag:
            # finalize file
            self.writer.finish()
