#!/bin/bash

#SBATCH --job-name=tpp
#SBATCH --partition=SCT
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=8
#SBATCH --mem=32G
#SBATCH --qos=normal
#SBATCH --output=R-out_%j.txt
#SBATCH --error=R-err_%j.txt

model_name=thp
gpu=0

# python3 ../batch_task_worker.py \
#         --procedure_name TPP \
#         --script_type train \
#         --dataset syn \
#         --model $model_name \
#         --GPU $gpu

# python3 ../batch_task_worker.py \
#         --procedure_name TPP \
#         --script_type plot \
#         --dataset syn \
#         --model $model_name \
#         --GPU $gpu

python3 ../batch_task_worker.py \
        --procedure_name TPP \
        --script_type train \
        --dataset real \
        --model $model_name \
        --GPU $gpu

python3 ../batch_task_worker.py \
        --procedure_name TPP \
        --script_type plot \
        --dataset real \
        --model $model_name \
        --GPU $gpu