# from smac.env import MultiAgentEnv, StarCraft2Env
from functools import partial
from .multiagentenv import MultiAgentEnv
from .starcraft2.starcraft2 import StarCraft2Env
from .matrix.matrix_game_1 import Matrix_gameEnv_1
from .matrix.matrix_game_2 import Matrix_gameEnv_2
from .matrix.nstep_matrix import NStepMatrixGame
import sys
import os

def env_fn(env, **kwargs) -> MultiAgentEnv:
    return env(**kwargs)

REGISTRY = {}
REGISTRY["sc2"] = partial(env_fn, env=StarCraft2Env)
REGISTRY["matrix_game_1"] = partial(env_fn, env=Matrix_gameEnv_1)
REGISTRY["matrix_game_2"] = partial(env_fn, env=Matrix_gameEnv_2)
REGISTRY["nstep_matrix"] = partial(env_fn, env=NStepMatrixGame)

if sys.platform == "linux":
   os.environ.setdefault("SC2PATH",
                         os.path.join(os.getcwd(), "3rdparty", "StarCraftII"))

