Thanks for your contribution to [OpenMixup](https://github.com/Westlake-AI/openmixup) and we appreciate it a lot. The following instructions would make your pull request more healthy and more easily get feedback. Currently, we follow the standard in MMLab, e.g., [MMClassification](https://github.com/open-mmlab/mmclassification). If you do not understand some items, don't worry, just make the pull request and seek help from maintainers.

## Motivation

Please describe the motivation of this PR and the goal you want to achieve through this PR.

## Modification

Please briefly describe what modification is made in this PR.

## BC-breaking (Optional)

Does the modification introduce changes that break the backward compatibility of the downstream repositories?
If so, please describe how it breaks the compatibility and how the downstream projects should modify their code to keep compatibility with this PR.

## Use cases (Optional)

If this PR introduces a new feature, it is better to list some use cases here and update the documentation.

## Checklist

**Before PR**:

- [ ] Pre-commit or other linting tools are used to fix the potential lint issues.
- [ ] Bug fixes are fully covered by unit tests, the case that causes the bug should be added in the unit tests.
- [ ] The modification is covered by complete unit tests. If not, please add more unit test to ensure the correctness.
- [ ] The documentation has been modified accordingly, like docstring or example tutorials.

**After PR**:

- [ ] If the modification has potential influence on downstream or other related projects, this PR should be tested with those projects, like MMDet or MMSeg.
- [ ] CLA has been signed and all committers have signed the CLA in this PR.
