# Model Zoo of Supervised Learning

**Some of the current results of supervised learning benchmarks are based on [MMClassification](https://github.com/open-mmlab/mmselfsup). We will rerun the experiments and update more reliable results soon!**

**Note**

* We summarize benchmark results in Markdown tables. You can convert them into other formats (e.g., LaTeX) with [online tools](https://www.tablesgenerator.com/markdown_tables).
* Models with \* are converted from the corresponding official repos, others are trained by ourselves.
* For [MogaNet](https://arxiv.org/abs/2211.03295) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/)], \* denotes the refined training setting of lightweight models with [3-Augment](https://arxiv.org/abs/2204.07118).
  
    <details open>
    <summary>Currently supported backbones</summary>
- [x] [AlexNet](https://dl.acm.org/doi/10.1145/3065386) (NIPS'2012) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/alexnet/)]
- [x] [VGG](https://arxiv.org/abs/1409.1556) (ICLR'2015) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vgg/)]
- [x] [InceptionV3](https://arxiv.org/abs/1512.00567) (CVPR'2016) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/inception_v3/)]
- [x] [ResNet](https://openaccess.thecvf.com/content_cvpr_2016/html/He_Deep_Residual_Learning_CVPR_2016_paper.html) (CVPR'2016) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/resnet/)]
- [x] [ResNeXt](https://arxiv.org/abs/1611.05431) (CVPR'2017) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/resnet/)]
- [x] [SE-ResNet](https://arxiv.org/abs/1709.01507) (CVPR'2018) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/resnet/)]
- [x] [SE-ResNeXt](https://arxiv.org/abs/1709.01507) (CVPR'2018) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/resnet/)]
- [x] [ShuffleNetV1](https://arxiv.org/abs/1807.11164) (CVPR'2018) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/shufflenet_v1/)]
- [x] [ShuffleNetV2](https://arxiv.org/abs/1807.11164) (ECCV'2018) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/shufflenet_v2/)]
- [x] [MobileNetV2](https://arxiv.org/abs/1801.04381) (CVPR'2018) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/mobilenet_v2/)]
- [x] [MobileNetV3](https://arxiv.org/abs/1905.02244) (ICCV'2019)
- [x] [EfficientNet](https://arxiv.org/abs/1905.11946) (ICML'2019) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/)]
- [x] [Res2Net](https://arxiv.org/abs/1904.01169) (ArXiv'2019) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/res2net/)]
- [x] [RegNet](https://arxiv.org/abs/2003.13678) (CVPR'2020) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/)]
- [x] [Vision-Transformer](https://arxiv.org/abs/2010.11929) (ICLR'2021) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vision_transformer/)]
- [x] [Swin-Transformer](https://arxiv.org/abs/2103.14030) (ICCV'2021) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/swin_transformer/)]
- [x] [PVT](https://arxiv.org/abs/2102.12122) (ICCV'2021) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/pvt/)]
- [x] [T2T-ViT](https://arxiv.org/abs/2101.11986) (ICCV'2021) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/t2t_vit/)]
- [x] [RepVGG](https://arxiv.org/abs/2101.03697) (CVPR'2021) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/)]
- [x] [DeiT](https://arxiv.org/abs/2012.12877) (ICML'2021) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/)]
- [x] [MLP-Mixer](https://arxiv.org/abs/2105.01601) (NIPS'2021) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/mlp_mixer/)]
- [x] [Twins](https://proceedings.neurips.cc/paper/2021/hash/4e0928de075538c593fbdabb0c5ef2c3-Abstract.html) (NIPS'2021) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/twins/)]
- [x] [ConvMixer](https://arxiv.org/abs/2201.09792) (Openreview'2021) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convmixer/)]
- [x] [UniFormer](https://arxiv.org/abs/2201.09450) (ICLR'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/uniformer/)]
- [x] [PoolFormer](https://arxiv.org/abs/2111.11418) (CVPR'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/)]
- [x] [ConvNeXt](https://arxiv.org/abs/2201.03545) (CVPR'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/)]
- [x] [MViTV2](https://arxiv.org/abs/2112.01526) (CVPR'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/mvit/)]
- [x] [RepMLP](https://arxiv.org/abs/2105.01883) (CVPR'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repmlp/)]
- [x] [VAN](https://arxiv.org/abs/2202.09741) (ArXiv'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/)]
- [x] [DeiT-3](https://arxiv.org/abs/2204.07118) (ECCV'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit3/)]
- [x] [LITv2](https://arxiv.org/abs/2205.13213) (NIPS'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/lit_v2/)]
- [x] [HorNet](https://arxiv.org/abs/2207.14284) (NIPS'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/hornet/)]
- [x] [EdgeNeXt](https://arxiv.org/abs/2206.10589) (ECCVW'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/edgenext/)]
- [x] [EfficientFormer](https://arxiv.org/abs/2206.01191) (ArXiv'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientformer/)]
- [x] [MogaNet](https://arxiv.org/abs/2211.03295) (ArXiv'2022) [[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/)]
    </details>

## ImageNet
ImageNet has multiple versions, but the most commonly used one is [ILSVRC 2012](http://www.image-net.org/challenges/LSVRC/2012/). We summarize image classification results of the official settings. You can download model files from [OpenMMLab](https://github.com/open-mmlab/mmpretrain) or [OpenMixup](https://github.com/Westlake-AI/openmixup/releases/tag/open-in1k-weights).

| Model | Params(M) | Flops(G) | Top-1 (%) | Top-5 (%) | Config | Download |
|:---:|:---:|:---:|:---:|:---:|:---:|:---:|
| AlexNet | 61.1 | 0.72 | 62.5 | 83.0 | [config](./alexnet_4xb64_cos_ep100.py) |
|  VGG-11   |  132.86   |   7.63   |   68.75   |   88.87   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vgg/vgg11_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/vgg/vgg11_batch256_imagenet_20210208-4271cd6c.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/vgg/vgg11_batch256_imagenet_20210208-4271cd6c.log.json) |
|  VGG-13   |  133.05   |  11.34   |   70.02   |   89.46   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vgg/vgg13_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/vgg/vgg13_batch256_imagenet_20210208-4d1d6080.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/vgg/vgg13_batch256_imagenet_20210208-4d1d6080.log.json) |
|  VGG-16   |  138.36   |   15.5   |   71.62   |   90.49   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vgg/vgg16_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/vgg/vgg16_batch256_imagenet_20210208-db26f1a5.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/vgg/vgg16_batch256_imagenet_20210208-db26f1a5.log.json) |
|  VGG-19   |  143.67   |  19.67   |   72.41   |   90.80   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vgg/vgg19_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/vgg/vgg19_batch256_imagenet_20210208-e6920e4a.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/vgg/vgg19_batch256_imagenet_20210208-e6920e4a.log.json) |
| VGG-11-BN |  132.87   |   7.64   |   70.67   |   90.16   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vgg/vgg11_bn_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/vgg/vgg11_bn_batch256_imagenet_20210207-f244902c.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/vgg/vgg11_bn_batch256_imagenet_20210207-f244902c.log.json) |
| VGG-13-BN |  133.05   |  11.36   |   72.12   |   90.66   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vgg/vgg13_bn_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/vgg/vgg13_bn_batch256_imagenet_20210207-1a8b7864.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/vgg/vgg13_bn_batch256_imagenet_20210207-1a8b7864.log.json) |
| VGG-16-BN |  138.37   |  15.53   |   73.74   |   91.66   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vgg/vgg16_bn_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/vgg/vgg16_bn_batch256_imagenet_20210208-7e55cd29.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/vgg/vgg16_bn_batch256_imagenet_20210208-7e55cd29.log.json) |
| VGG-19-BN |  143.68   |   19.7   |   74.68   |   92.27   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vgg/vgg19_bn_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/vgg/vgg19_bn_batch256_imagenet_20210208-da620c4f.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/vgg/vgg19_bn_batch256_imagenet_20210208-da620c4f.log.json) |
| Inception V3\* | 23.83 | 5.75 | 77.57 | 93.58 | [config](./inception_v3_4xb64_cos_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/inception-v3/inception-v3_3rdparty_8xb32_in1k_20220615-dcd4d910.pth) |
|     ResNet-18      |   11.69   |   1.82   |   69.90   |   89.43   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet18_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnet18_8xb32_in1k_20210831-fbbb1da6.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnet18_8xb32_in1k_20210831-fbbb1da6.log.json) |
|     ResNet-34      |   21.8    |   3.68   |   73.62   |   91.59   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet34_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnet34_8xb32_in1k_20210831-f257d4e6.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnet34_8xb32_in1k_20210831-f257d4e6.log.json) |
|     ResNet-50      |   25.56   |   4.12   |   76.55   |   93.06   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet50_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnet50_8xb32_in1k_20210831-ea4938fc.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnet50_8xb32_in1k_20210831-ea4938fc.log.json) |
|     ResNet-101     |   44.55   |   7.85   |   77.97   |   94.06   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet101_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnet101_8xb32_in1k_20210831-539c63f8.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnet101_8xb32_in1k_20210831-539c63f8.log.json) |
|     ResNet-152     |   60.19   |  11.58   |   78.48   |   94.13   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet152_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnet152_8xb32_in1k_20210901-4d7582fa.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnet152_8xb32_in1k_20210901-4d7582fa.log.json) |
|    ResNetV1C-50    |   25.58   |   4.36   |   77.01   |   93.58   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnetv1c50_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1c50_8xb32_in1k_20220214-3343eccd.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1c50_8xb32_in1k_20220214-3343eccd.log.json) |
|   ResNetV1C-101    |   44.57   |   8.09   |   78.30   |   94.27   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnetv1c101_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1c101_8xb32_in1k_20220214-434fe45f.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1c101_8xb32_in1k_20220214-434fe45f.log.json) |
|   ResNetV1C-152    |   60.21   |  11.82   |   78.76   |   94.41   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnetv1c152_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1c152_8xb32_in1k_20220214-c013291f.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1c152_8xb32_in1k_20220214-c013291f.log.json) |
|    ResNetV1D-50    |   25.58   |   4.36   |   77.54   |   93.57   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnetv1d50_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1d50_b32x8_imagenet_20210531-db14775a.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1d50_b32x8_imagenet_20210531-db14775a.log.json) |
|   ResNetV1D-101    |   44.57   |   8.09   |   78.93   |   94.48   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnetv1d101_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1d101_b32x8_imagenet_20210531-6e13bcd3.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1d101_b32x8_imagenet_20210531-6e13bcd3.log.json) |
|   ResNetV1D-152    |   60.21   |  11.82   |   79.41   |   94.70   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnetv1d152_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1d152_b32x8_imagenet_20210531-278cf22a.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnetv1d152_b32x8_imagenet_20210531-278cf22a.log.json) |
|  ResNet-50 (fp16)  |   25.56   |   4.12   |   76.30   |   93.07   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet50_8xb32-fp16_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/fp16/resnet50_batch256_fp16_imagenet_20210320-b3964210.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/fp16/resnet50_batch256_fp16_imagenet_20210320-b3964210.log.json) |
|  Wide-ResNet-50\*  |   68.88   |  11.44   |   78.48   |   94.08   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/wide-resnet50_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/wide-resnet50_3rdparty_8xb32_in1k_20220304-66678344.pth) |
| Wide-ResNet-101\*  |  126.89   |  22.81   |   78.84   |   94.28   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet101_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/wide-resnet101_3rdparty_8xb32_in1k_20220304-8d5f9d61.pth) |
| ResNet-50 (rsb-a1) |   25.56   |   4.12   |   80.12   |   94.78   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet50_8xb256-rsb-a1-600e_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnet50_8xb256-rsb-a1-600e_in1k_20211228-20e21305.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnet50_8xb256-rsb-a1-600e_in1k_20211228-20e21305.log.json) |
| ResNet-50 (rsb-a2) |   25.56   |   4.12   |   79.55   |   94.37   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet50_8xb256-rsb-a2-300e_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnet50_8xb256-rsb-a2-300e_in1k_20211228-0fd8be6e.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnet50_8xb256-rsb-a2-300e_in1k_20211228-0fd8be6e.log.json) |
| ResNet-50 (rsb-a3) |   25.56   |   4.12   |   78.30   |   93.80   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/resnet/resnet50_8xb256-rsb-a3-100e_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/resnet/resnet50_8xb256-rsb-a3-100e_in1k_20211228-3493673c.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/resnet/resnet50_8xb256-rsb-a3-100e_in1k_20211228-3493673c.log.json) |
| ShuffleNetV1 1.0x |   1.87    |  0.146   |   68.13   |   87.81   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/shufflenet_v1/shufflenet_v1_1x_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/shufflenet_v1/shufflenet_v1_batch1024_imagenet_20200804-5d6cec73.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/shufflenet_v1/shufflenet_v1_batch1024_imagenet_20200804-5d6cec73.log.json) |
| ShuffleNetV2 1.0x |   2.28    |  0.149   |   69.55   |   88.92   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/shufflenet/shufflenet_v2_1x_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/shufflenet_v2/shufflenet_v2_batch1024_imagenet_20200812-5bf4721e.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/shufflenet_v2/shufflenet_v2_batch1024_imagenet_20200804-8860eec9.log.json) |
| MobileNet V2 |    3.5    |  0.319   |   71.86   |   90.42   | [config](https://github.com/open-mmlab/mmclassification/blob/master/configs/mobilenet_v2/mobilenet-v2_8xb32_in1k.py) | [model](https://download.openmmlab.com/mmclassification/v0/mobilenet_v2/mobilenet_v2_batch256_imagenet_20200708-3b2dc3af.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/mobilenet_v2/mobilenet_v2_batch256_imagenet_20200708-3b2dc3af.log.json) |
|        EfficientNet-B0\*         |   5.29    |   0.02   |   76.74   |   93.17   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b0_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b0_3rdparty_8xb32_in1k_20220119-a7e2a0b1.pth) |
|      EfficientNet-B0 (AA)\*      |   5.29    |   0.02   |   77.26   |   93.41   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b0_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b0_3rdparty_8xb32-aa_in1k_20220119-8d939117.pth) |
| EfficientNet-B0 (AA + AdvProp)\* |   5.29    |   0.02   |   77.53   |   93.61   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b0_4xb64_05norm.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b0_3rdparty_8xb32-aa-advprop_in1k_20220119-26434485.pth) |
|        EfficientNet-B1\*         |   7.79    |   0.03   |   78.68   |   94.28   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b1_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b1_3rdparty_8xb32_in1k_20220119-002556d9.pth) |
|      EfficientNet-B1 (AA)\*      |   7.79    |   0.03   |   79.20   |   94.42   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b1_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b1_3rdparty_8xb32-aa_in1k_20220119-619d8ae3.pth) |
| EfficientNet-B1 (AA + AdvProp)\* |   7.79    |   0.03   |   79.52   |   94.43   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b1_4xb64_05norm.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b1_3rdparty_8xb32-aa-advprop_in1k_20220119-5715267d.pth) |
|        EfficientNet-B2\*         |   9.11    |   0.03   |   79.64   |   94.80   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b2_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b2_3rdparty_8xb32_in1k_20220119-ea374a30.pth) |
|      EfficientNet-B2 (AA)\*      |   9.11    |   0.03   |   80.21   |   94.96   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b2_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b2_3rdparty_8xb32-aa_in1k_20220119-dd61e80b.pth) |
| EfficientNet-B2 (AA + AdvProp)\* |   9.11    |   0.03   |   80.45   |   95.07   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b2_4xb64_05norm.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b2_3rdparty_8xb32-aa-advprop_in1k_20220119-1655338a.pth) |
|        EfficientNet-B3\*         |   12.23   |   0.06   |   81.01   |   95.34   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b3_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b3_3rdparty_8xb32_in1k_20220119-4b4d7487.pth) |
|      EfficientNet-B3 (AA)\*      |   12.23   |   0.06   |   81.58   |   95.67   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b3_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b3_3rdparty_8xb32-aa_in1k_20220119-5b4887a0.pth) |
| EfficientNet-B3 (AA + AdvProp)\* |   12.23   |   0.06   |   81.81   |   95.69   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b3_4xb64_05norm.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b3_3rdparty_8xb32-aa-advprop_in1k_20220119-53b41118.pth) |
|        EfficientNet-B4\*         |   19.34   |   0.12   |   82.57   |   96.09   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b4_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b4_3rdparty_8xb32_in1k_20220119-81fd4077.pth) |
|      EfficientNet-B4 (AA)\*      |   19.34   |   0.12   |   82.95   |   96.26   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b4_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b4_3rdparty_8xb32-aa_in1k_20220119-45b8bd2b.pth) |
| EfficientNet-B4 (AA + AdvProp)\* |   19.34   |   0.12   |   83.25   |   96.44   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b4_4xb64_05norm.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b4_3rdparty_8xb32-aa-advprop_in1k_20220119-38c2238c.pth) |
|        EfficientNet-B5\*         |   30.39   |   0.24   |   83.18   |   96.47   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b5_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b5_3rdparty_8xb32_in1k_20220119-e9814430.pth) |
|      EfficientNet-B5 (AA)\*      |   30.39   |   0.24   |   83.82   |   96.76   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b5_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b5_3rdparty_8xb32-aa_in1k_20220119-2cab8b78.pth) |
| EfficientNet-B5 (AA + AdvProp)\* |   30.39   |   0.24   |   84.21   |   96.98   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b5_4xb64_05norm.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b5_3rdparty_8xb32-aa-advprop_in1k_20220119-f57a895a.pth) |
|      EfficientNet-B6 (AA)\*      |   43.04   |   0.41   |   84.05   |   96.82   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b6_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b6_3rdparty_8xb32-aa_in1k_20220119-45b03310.pth) |
| EfficientNet-B6 (AA + AdvProp)\* |   43.04   |   0.41   |   84.74   |   97.14   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b6_4xb64_05norm.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b6_3rdparty_8xb32-aa-advprop_in1k_20220119-bfe3485e.pth) |
|      EfficientNet-B7 (AA)\*      |   66.35   |   0.72   |   84.38   |   96.88   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b7_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b7_3rdparty_8xb32-aa_in1k_20220119-bf03951c.pth) |
| EfficientNet-B7 (AA + AdvProp)\* |   66.35   |   0.72   |   85.14   |   97.23   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b7_4xb64_05norm.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b7_3rdparty_8xb32-aa-advprop_in1k_20220119-c6dbff10.pth) |
| EfficientNet-B8 (AA + AdvProp)\* |   87.41   |   1.09   |   85.38   |   97.28   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientnet/efficientnet_b8_4xb64.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientnet/efficientnet-b8_3rdparty_8xb32-aa-advprop_in1k_20220119-297ce1b7.pth) |
| Res2Net-50-14w-8s\*  |   25.06   |   4.22   |   78.14   |   93.85   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/res2net/res2net50_w14_s8_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/res2net/res2net50-w14-s8_3rdparty_8xb32_in1k_20210927-bc967bf1.pth) |
| Res2Net-50-26w-8s\*   |   48.40   |   8.39   |   79.20   |   94.36   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/res2net/res2net50_w26_s8_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/res2net/res2net50-w26-s8_3rdparty_8xb32_in1k_20210927-f547a94b.pth) |
| Res2Net-101-26w-4s\*  |   45.21   |   8.12   |   79.19   |   94.44   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/res2net/res2net101_w26_s4_4xb64_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/res2net/res2net101-w26-s4_3rdparty_8xb32_in1k_20210927-870b6c36.pth) |
|  RegNetX-400MF  |   5.16    |   0.41   |   72.56   |   90.78   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_400mf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-400mf_8xb128_in1k_20211213-89bfc226.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-400mf_8xb128_in1k_20211208_143316.log.json) |
|  RegNetX-800MF  |   7.26    |   0.81   |   74.76   |   92.32   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_800mf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-800mf_8xb128_in1k_20211213-222b0f11.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-800mf_8xb128_in1k_20211207_143037.log.json) |
|  RegNetX-1.6GF  |   9.19    |   1.63   |   76.84   |   93.31   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_1_6gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-1.6gf_8xb128_in1k_20211213-d1b89758.pth) \| [log](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-1.6gf_8xb128_in1k_20211208_143018.log.json) |
|  RegNetX-3.2GF  |   15.3    |   3.21   |   78.09   |   94.08   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_3_2gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-3.2gf_8xb64_in1k_20211213-1fdd82ae.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-3.2gf_8xb64_in1k_20211208_142720.log.json) |
|  RegNetX-4.0GF  |   22.12   |   4.0    |   78.60   |   94.17   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_4_0gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-4.0gf_8xb64_in1k_20211213-efed675c.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-4.0gf_8xb64_in1k_20211207_150431.log.json) |
|  RegNetX-6.4GF  |   26.21   |   6.51   |   79.38   |   94.65   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_6_4gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-6.4gf_8xb64_in1k_20211215-5c6089da.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-6.4gf_8xb64_in1k_20211213_172748.log.json) |
|  RegNetX-8.0GF  |   39.57   |   8.03   |   79.12   |   94.51   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_8_0gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-8.0gf_8xb64_in1k_20211213-9a9fcc76.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-8.0gf_8xb64_in1k_20211208_103250.log.json) |
|  RegNetX-12GF   |   46.11   |  12.15   |   79.67   |   95.03   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_12gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-12gf_8xb64_in1k_20211213-5df8c2f8.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/regnet/regnetx-12gf_8xb64_in1k_20211208_143713.log.json) |
| RegNetX-400MF\* |   5.16    |   0.41   |   72.55   |   90.91   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_400mf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/convert/RegNetX-400MF-0db9f35c.pth) |
| RegNetX-800MF\* |   7.26    |   0.81   |   75.21   |   92.37   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_800mf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/convert/RegNetX-800MF-4f9d1e8a.pth) |
| RegNetX-1.6GF\* |   9.19    |   1.63   |   77.04   |   93.51   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_1_6gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/convert/RegNetX-1.6GF-cfb32375.pth) |
| RegNetX-3.2GF\* |   15.3    |   3.21   |   78.26   |   94.20   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_3_2gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/convert/RegNetX-3.2GF-82c43fd5.pth) |
| RegNetX-4.0GF\* |   22.12   |   4.0    |   78.72   |   94.22   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_4_0gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/convert/RegNetX-4.0GF-ef8bb32c.pth) |
| RegNetX-6.4GF\* |   26.21   |   6.51   |   79.22   |   94.61   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_6_4gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/convert/RegNetX-6.4GF-6888c0ea.pth) |
| RegNetX-8.0GF\* |   39.57   |   8.03   |   79.31   |   94.57   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_8_0gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/convert/RegNetX-8.0GF-cb4c77ec.pth) |
| RegNetX-12GF\*  |   46.11   |  12.15   |   79.91   |   94.78   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/regnet/regnetx_12gf_8xb128_ep100.py) | [model](https://download.openmmlab.com/mmclassification/v0/regnet/convert/RegNetX-12GF-0574538f.pth) |
|   ViT-B16\*   |   86.86   |  33.03   |   85.43   |   97.77   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vision_transformer/vit_base_p16_sz384_8xb64_accu8_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/vit/finetune/vit-base-p16_in21k-pre-3rdparty_ft-64xb64_in1k-384_20210928-98e8652b.pth) |
|   ViT-B32\*   |   88.30   |   8.56   |   84.01   |   97.08   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vision_transformer/vit_base_p32_sz384_8xb64_accu8_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/vit/finetune/vit-base-p32_in21k-pre-3rdparty_ft-64xb64_in1k-384_20210928-9cea8599.pth) |
|   ViT-L16\*   |  304.72   |  116.68  |   85.63   |   97.63   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/vision_transformer/vit_large_p16_sz384_8xb64_accu8_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/vit/finetune/vit-large-p16_in21k-pre-3rdparty_ft-64xb64_in1k-384_20210928-b20ba619.pth) |
|  Swin-T  |   28.29   |   4.36   |   81.18   |   95.61   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/swin_transformer/swin_tiny_8xb128_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/swin-transformer/swin_tiny_224_b16x64_300e_imagenet_20210616_090925-66df6be6.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/swin-transformer/swin_tiny_224_b16x64_300e_imagenet_20210616_090925.log.json) |
|  Swin-S  |   49.61   |   8.52   |   83.02   |   96.29   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/swin_transformer/swin_small_8xb128_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/swin-transformer/swin_small_224_b16x64_300e_imagenet_20210615_110219-7f9d988b.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/swin-transformer/swin_small_224_b16x64_300e_imagenet_20210615_110219.log.json) |
|  Swin-B  |   87.77   |  15.14   |   83.36   |   96.44   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/swin_transformer/swin_base_8xb128_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/swin-transformer/swin_base_224_b16x64_300e_imagenet_20210616_190742-93230b0d.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/swin-transformer/swin_base_224_b16x64_300e_imagenet_20210616_190742.log.json) |
|  PVT-Tiny\*  |    13.2   |   1.60   |    75.1   | - |[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/pvt/pvt_tiny_8xb128_ep300.py)  |  [model](https://github.com/whai362/PVT/releases/download/v2/pvt_tiny.pth) / log  |
|  PVT-Small\* |    24.5   |   3.80   |    79.8   | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/pvt/pvt_small_8xb128_ep300.py) |  [model](https://github.com/whai362/PVT/releases/download/v2/pvt_small.pth) / log |
| PVT-Medium\* |    44.2   |   6.70   |    81.2   | - |[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/pvt/pvt_medium_8xb128_ep300.py) |  [model](https://github.com/whai362/PVT/releases/download/v2/pvt_small.pth) / log |
|  PVT-Large\* |    61.2   |   9.80   |    81.7   | - |[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/pvt/pvt_large_8xb128_ep300.py) | [model](https://github.com/whai362/PVT/releases/download/v2/pvt_small.pth)  / log |
| T2T-ViT_t-14 |   21.47   |   4.34   |   81.83   |   95.84   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/t2t_vit/t2t_vit_tiny_14_ema_8xb64_ep310.py) | [model](https://download.openmmlab.com/mmclassification/v0/t2t-vit/t2t-vit-t-14_8xb64_in1k_20211220-f7378dd5.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/t2t-vit/t2t-vit-t-14_8xb64_in1k_20211220-f7378dd5.log.json) |
| T2T-ViT_t-19 |   39.08   |   7.80   |   82.63   |   96.18   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/t2t_vit/t2t_vit_tiny_19_ema_8xb64_ep310.py) | [model](https://download.openmmlab.com/mmclassification/v0/t2t-vit/t2t-vit-t-19_8xb64_in1k_20211214-7f5e3aaf.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/t2t-vit/t2t-vit-t-19_8xb64_in1k_20211214-7f5e3aaf.log.json) |
| T2T-ViT_t-24 |   64.00   |  12.69   |   82.71   |   96.09   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/t2t_vit/t2t_vit_tiny_24_ema_8xb64_ep310.py) | [model](https://download.openmmlab.com/mmclassification/v0/t2t-vit/t2t-vit-t-24_8xb64_in1k_20211214-b2a68ae3.pth)  \| [log](https://download.openmmlab.com/mmclassification/v0/t2t-vit/t2t-vit-t-24_8xb64_in1k_20211214-b2a68ae3.log.json) |
|  RepVGG-A0\*  |   9.11（train) \| 8.31 (deploy)   |  1.52 (train) \| 1.36 (deploy)  |   72.41   |   90.50   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_A0_4xb64_ep120.py) \| [config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_A0_deploy_4xb64_ep120.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-A0_3rdparty_4xb64-coslr-120e_in1k_20210909-883ab98c.pth) |
|  RepVGG-A1\*  |  14.09 (train) \| 12.79 (deploy)  |  2.64 (train) \| 2.37 (deploy)  |   74.47   |   91.85   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_A1_4xb64_ep120.py) \| [config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_A1_deploy_4xb64_ep120.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-A1_3rdparty_4xb64-coslr-120e_in1k_20210909-24003a24.pth) |
|  RepVGG-A2\*  |  28.21 (train) \| 25.5 (deploy)   |  5.7 (train)  \| 5.12 (deploy)  |   76.48   |   93.01   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_A2_4xb64_ep120.py) \|[config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_A2_deploy_4xb64_ep120.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-A2_3rdparty_4xb64-coslr-120e_in1k_20210909-97d7695a.pth) |
|  RepVGG-B0\*  |  15.82 (train) \| 14.34 (deploy)  |  3.42 (train) \| 3.06 (deploy)  |   75.14   |   92.42   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_B0_4xb64_ep120.py) \|[config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_B0_deploy_4xb64_ep120.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-B0_3rdparty_4xb64-coslr-120e_in1k_20210909-446375f4.pth) |
|  RepVGG-B1\*  |  57.42 (train) \| 51.83 (deploy)  | 13.16 (train) \| 11.82 (deploy) |   78.37   |   94.11   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_B1_4xb64_ep120.py) \|[config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_B1_deploy_4xb64_ep120.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-B1_3rdparty_4xb64-coslr-120e_in1k_20210909-750cdf67.pth) |
| RepVGG-B1g2\* |  45.78 (train) \| 41.36 (deploy)  |  9.82 (train) \| 8.82 (deploy)  |   77.79   |   93.88   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_B1g2_4xb64_ep120.py) \|[config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_B1g2_deploy_4xb64_ep120.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-B1g2_3rdparty_4xb64-coslr-120e_in1k_20210909-344f6422.pth) |
| RepVGG-B1g4\* |  39.97 (train) \| 36.13 (deploy)  |  8.15 (train) \| 7.32 (deploy)  |   77.58   |   93.84   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_B1g4_4xb64_ep120.py) \|[config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_B1g4_deploy_4xb64_ep120.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-B1g4_3rdparty_4xb64-coslr-120e_in1k_20210909-d4c1a642.pth) |
|  RepVGG-B2\*  |  89.02 (train) \| 80.32 (deploy)  | 20.46 (train) \| 18.39 (deploy) |   78.78   |   94.42   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_B2_4xb64_ep120.py) \|[config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_B2_deploy_4xb64_ep120.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-B2_3rdparty_4xb64-coslr-120e_in1k_20210909-bd6b937c.pth) |
| RepVGG-B2g4\* |  61.76 (train) \| 55.78 (deploy)  | 12.63 (train) \| 11.34 (deploy) |   79.38   |   94.68   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_B2g4_autoaug_mixup_4xb64_ep200.py) \|[config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_B2g4_deploy_autoaug_mixup_4xb64_ep200.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-B2g4_3rdparty_4xb64-autoaug-lbs-mixup-coslr-200e_in1k_20210909-7b7955f0.pth) |
|  RepVGG-B3\*  | 123.09 (train) \| 110.96 (deploy) | 29.17 (train) \| 26.22 (deploy) |   80.52   |   95.26   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_B3_autoaug_mixup_4xb64_ep200.py) \|[config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_B3_deploy_autoaug_mixup_4xb64_ep200.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-B3_3rdparty_4xb64-autoaug-lbs-mixup-coslr-200e_in1k_20210909-dda968bf.pth) |
| RepVGG-D2se\* | 133.33 (train) \| 120.39 (deploy) | 36.56 (train) \| 32.85 (deploy) |   81.81   |   95.94   | [config (train)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/repvgg_D2se_autoaug_mixup_4xb64_ep200.py) \|[config (deploy)](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repvgg/deploy/repvgg_D2se_deploy_autoaug_mixup_4xb64_ep200.py) | [model](https://download.openmmlab.com/mmclassification/v0/repvgg/repvgg-D2se_3rdparty_4xb64-autoaug-lbs-mixup-coslr-200e_in1k_20210909-cf3139b7.pth) |
|  DeiT-T   |   5.72    |   1.08   |   73.56   |   91.16   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/deit_tiny_8xb128_ep300.py) | model | log |
|  DeiT-T distilled\* |   5.72    |   1.08   |   72.20   |   91.10   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/deit_tiny_8xb128_ep300.py) | [model](https://dl.fbaipublicfiles.com/deit/deit_tiny_patch16_224-a1311bcf.pth) |
|  DeiT-S   |   22.05   |   4.24   |   79.93   |   95.14   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/deit_small_8xb128_ep300.py) | model | log |
|  DeiT-S distilled\* |    22.05   |   4.24   |   79.90   |   95.10   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/deit_small_8xb128_ep300.py) | [model](https://dl.fbaipublicfiles.com/deit/deit_small_patch16_224-cd65a155.pth) |
|  DeiT-B   |   86.57   |   16.86  |   81.82   |   95.57   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/deit_base_8xb128_ep300.py) | model | log |
|  DeiT-B distilled\* |   86.57   |   16.86  |   81.80   |   95.60   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/deit_base_8xb128_ep300.py) | [model](https://dl.fbaipublicfiles.com/deit/deit_base_patch16_224-b5f2ef4d.pth) |
| Mixer-B/16\* |   59.88   |  12.61   |   76.68   |   92.25   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/mlp_mixer/mlp_mixer_base_p16_8xb128_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/mlp-mixer/mixer-base-p16_3rdparty_64xb64_in1k_20211124-1377e3e0.pth) |
| Mixer-L/16\* |   208.2   |  44.57   |   72.34   |   88.02   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/mlp_mixer/mlp_mixer_large_p16_8xb64_accu2_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/mlp-mixer/mixer-large-p16_3rdparty_64xb64_in1k_20211124-5a2519d2.pth) |
| PCPVT-small\* |   24.11   |   3.67   |   81.14   |   95.69   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/twins/twins_pcpvt_small_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/twins/twins-pcpvt-small_3rdparty_8xb128_in1k_20220126-ef23c132.pth) |
| PCPVT-base\*  |   43.83   |   6.45   |   82.66   |   96.26   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/twins/twins_pcpvt_base_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/twins/twins-pcpvt-base_3rdparty_8xb128_in1k_20220126-f8c4b0d5.pth) |
| PCPVT-large\* |   60.99   |   9.51   |   83.09   |   96.59   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/twins/twins_pcpvt_large_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/twins/twins-pcpvt-large_3rdparty_16xb64_in1k_20220126-c1ef8d80.pth) |
|  SVT-small\*  |   24.06   |   2.82   |   81.77   |   95.57   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/twins/twins_svt_small_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/twins/twins-svt-small_3rdparty_8xb128_in1k_20220126-8fe5205b.pth) |
|  SVT-base\*   |   56.07   |   8.35   |   83.13   |   96.29   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/twins/twins_svt_base_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/twins/twins-svt-base_3rdparty_8xb128_in1k_20220126-e31cc8e9.pth) |
|  SVT-large\*  |   99.27   |  14.82   |   83.60   |   96.50   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/twins/twins_svt_large_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/twins/twins-svt-large_3rdparty_16xb64_in1k_20220126-4817645f.pth) |
| ConvMixer-768/32\*  |   21.11   |  19.62   |   80.16   |   95.08   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convmixer/convmixer_768_d32_8xb80_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/convmixer/convmixer-768-32_3rdparty_10xb64_in1k_20220323-bca1f7b8.pth) |
| ConvMixer-1024/20\* |   24.38   |   5.55   |   76.94   |   93.36   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convmixer/convmixer_1024_d20_8xb60_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/convmixer/convmixer-1024-20_3rdparty_10xb64_in1k_20220323-48f8aeba.pth) |
| ConvMixer-1536/20\* |   51.63   |  48.71   |   81.37   |   95.61   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convmixer/convmixer_1535_d20_8xb60_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/convmixer/convmixer-1536_20_3rdparty_10xb64_in1k_20220323-ea5786f3.pth) |
| UniFormer-T       |   5.55    |   0.88   |   78.02   | -| [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/uniformer/) | model / log |
| UniFormer-S       |   21.5    |   3.44   |   82.56   | -| [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/uniformer/) | model / log |
| UniFormer-S\*     |   21.5    |   3.44   |   82.90   | -| [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/uniformer/) | [model](https://drive.google.com/file/d/1-uepH3Q3BhTmWU6HK-sGAGQC_MpfIiPD/view?usp=sharing) | [log](https://drive.google.com/file/d/10ThKb9YOpCiHW8HL10dRuZ0lQSPJidO7/view?usp=sharing) |
| UniFormer-S + ConvStem\*    |   24.0    |   4.21   |   83.40   | -| [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/uniformer/) | [model](https://drive.google.com/file/d/1-uepH3Q3BhTmWU6HK-sGAGQC_MpfIiPD/view?usp=sharing) | [log](https://drive.google.com/file/d/10ThKb9YOpCiHW8HL10dRuZ0lQSPJidO7/view?usp=sharing) |
| UniFormer-B\*     |   49.8    |   8.27   |   83.90   | -| [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/uniformer/) | [model](https://drive.google.com/file/d/1-uepH3Q3BhTmWU6HK-sGAGQC_MpfIiPD/view?usp=sharing) | [log](https://drive.google.com/file/d/10ThKb9YOpCiHW8HL10dRuZ0lQSPJidO7/view?usp=sharing) |
| UniFormer-S + Token Labeling\*  |   21.5    |   3.44   |   83.40   | -| [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/uniformer/) | [model](https://drive.google.com/file/d/1-uepH3Q3BhTmWU6HK-sGAGQC_MpfIiPD/view?usp=sharing) | [log](https://drive.google.com/file/d/10ThKb9YOpCiHW8HL10dRuZ0lQSPJidO7/view?usp=sharing) |
| UniFormer-B + Token Labeling\*  |   49.8    |   8.27   |   85.10   | -| [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/uniformer/) | [model](https://drive.google.com/file/d/1-uepH3Q3BhTmWU6HK-sGAGQC_MpfIiPD/view?usp=sharing) | [log](https://drive.google.com/file/d/10ThKb9YOpCiHW8HL10dRuZ0lQSPJidO7/view?usp=sharing) |
| PoolFormer-S12\* |   11.92   |   1.87   |   77.24   |   93.51   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_s12_8xb128_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/poolformer/poolformer-s12_3rdparty_32xb128_in1k_20220414-f8d83051.pth) |
| PoolFormer-S24\* |   21.39   |   3.51   |   80.33   |   95.05   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_s24_8xb128_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/poolformer/poolformer-s24_3rdparty_32xb128_in1k_20220414-d7055904.pth) |
| PoolFormer-S36\* |   30.86   |   5.15   |   81.43   |   95.45   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_s36_8xb128_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/poolformer/poolformer-s36_3rdparty_32xb128_in1k_20220414-d78ff3e8.pth) |
| PoolFormer-M36\* |   56.17   |   8.96   |   82.14   |   95.71   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_m36_8xb128_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/poolformer/poolformer-m36_3rdparty_32xb128_in1k_20220414-c55e0949.pth) |
| PoolFormer-M48\* |   73.47   |  11.80   |   82.51   |   95.95   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_m48_8xb128_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/poolformer/poolformer-m48_3rdparty_32xb128_in1k_20220414-9378f3eb.pth) |
| ConvNeXt-T    |   28.59   |   4.46   |   82.16   |   95.91   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_tiny_8xb256_accu2_fp16_ep300.py) | model | log |
| ConvNeXt-T\*  |   28.59   |   4.46   |   82.05   |   95.86   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_tiny_8xb256_accu2_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/convnext/convnext-tiny_3rdparty_32xb128_in1k_20220124-18abde00.pth) |
| ConvNeXt-S\*  |   50.22   |   8.69   |   83.13   |   96.44   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_small_8xb128_accu4_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/convnext/convnext-small_3rdparty_32xb128_in1k_20220124-d39b5192.pth) |
| ConvNeXt-B\*  |   88.59   |  15.36   |   83.85   |   96.74   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_base_8xb128_accu4_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/convnext/convnext-base_3rdparty_32xb128_in1k_20220124-d0915162.pth) |
| ConvNeXt-L\*  |  197.77   |  34.37   |   84.30   |   96.89   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_large_8xb64_accu8_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/convnext/convnext-large_3rdparty_64xb64_in1k_20220124-f8a0ded0.pth) |
| ConvNeXt-XL\* |  350.20   |  60.93   |   86.97   |   98.20   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_xlarge_8xb64_accu8_fp16_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/convnext/convnext-xlarge_in21k-pre-3rdparty_64xb64_in1k_20220124-76b6863d.pth) |
| MViTv2-tiny\*  |   24.17   |   4.70   |   82.33   |   96.15   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/mvit/mvit_v2_tiny_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/mvit/mvitv2-tiny_3rdparty_in1k_20220722-db7beeef.pth) |
| MViTv2-small\* |   34.87   |   7.00   |   83.63   |   96.51   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/mvit/mvit_v2_small_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/mvit/mvitv2-small_3rdparty_in1k_20220722-986bd741.pth) |
| MViTv2-base\*  |   51.47   |  10.20   |   84.34   |   96.86   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/mvit/mvit_v2_base_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/mvit/mvitv2-base_3rdparty_in1k_20220722-9c4f0a17.pth) |
| MViTv2-large\* |  217.99   |  42.10   |   85.25   |   97.14   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/mvit/mvit_v2_large_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/mvit/mvitv2-large_3rdparty_in1k_20220722-2b57b983.pth) |
| RepMLP-B224\* |   68.24   |   6.71   |   80.41   |   95.12   | [train_cfg](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repmlp/repmlp_base_8xb64_ep300.py) \| [deploy_cfg](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repmlp/repmlp_base_deploy_8xb64_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/repmlp/repmlp-base_3rdparty_8xb64_in1k_20220330-1cb1f11b.pth) |
| RepMLP-B256\* |   96.45   |   9.69   |   81.11   |   95.5    | [train_cfg](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repmlp/repmlp_base_sz256_8xb64_ep300.py) \| [deploy_cfg](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/repmlp/repmlp_base_deploy_sz256_8xb64_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/repmlp/repmlp-base_3rdparty_8xb64_in1k-256px_20220330-7c5a91ce.pth) |
|  VAN-T  |   4.11   |   0.88   |   75.77   |   92.99   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_tiny_8xb128_ep300.py) |                                               model / log                                               |
| VAN-T\* |   4.11   |   0.88   |   75.41   |   93.02   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_tiny_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/van/van-tiny_8xb128_in1k_20220501-385941af.pth) |
|  VAN-S  |   13.86   |   2.52   |   81.03   |   95.56   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_small_8xb128_ep300.py) |                                               model / log                                               |
| VAN-S\* |   13.86   |   2.52   |   81.01   |   95.63   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_small_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/van/van-small_8xb128_in1k_20220501-17bc91aa.pth) |
| VAN-B    |  26.58   |   5.03   |   82.65   |   96.17   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_base_8xb128_ep300.py) |                                               model / log                                               |
| VAN-B\*  |  26.58   |   5.03   |   82.80   |   96.21   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_base_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/van/van-base_8xb128_in1k_20220501-6a4cc31b.pth) |
| VAN-L\*  |  44.77   |   8.99   |   83.86   |   96.73   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_large_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/van/van-large_8xb128_in1k_20220501-f212ba21.pth) |
| VAN-B4\* |   60.28   |  12.22   |   84.13   |   96.86   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_b4_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/van/van-b4_3rdparty_in1k_20220909-f4665b92.pth) |
|  LITv2-S  |     28    |    3.7                 |    81.7   | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/lit_v2/lit_v2_small_8xb128_cos_fp16_ep300.py) | model / log |
| LITv2-S\* |     28    |    3.7                 |    82.0   | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/lit_v2/lit_v2_small_8xb128_cos_fp16_ep300.py) | [model](https://github.com/ziplab/LITv2/releases/download/v1.0/litv2_s.pth) / [log](https://github.com/ziplab/LITv2/releases/download/v1.0/litv2_m_log.txt) |
| LITv2-M\* |     49    |    7.5                    |    83.3   | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/lit_v2/lit_v2_medium_8xb128_cos_fp16_ep300.py) | [model](https://github.com/ziplab/LITv2/releases/download/v1.0/litv2_m.pth) / [log](https://github.com/ziplab/LITv2/releases/download/v1.0/litv2_m_log.txt) |
| LITv2-B\* |     87    |   13.2                   |    84.7   | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/lit_v2/lit_v2_base_8xb128_cos_fp16_ep300.py) | [model](https://github.com/ziplab/LITv2/releases/download/v1.0/litv2_b.pth) / [log](https://github.com/ziplab/LITv2/releases/download/v1.0/litv2_b_log.txt) |
|  HorNet-T\*   |   22.41   |   3.98   |   82.84   |   96.24   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/hornet/hornet_tiny_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/hornet/hornet-tiny_3rdparty_in1k_20220909-13316b34.pth) |
| HorNet-T-GF\* |   22.99   |   3.9    |   82.98   |   96.38   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/hornet/hornet_tiny_gf_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/hornet/hornet-tiny-gf_3rdparty_in1k_20220909-954c0361.pth) |
|  HorNet-S\*   |   49.53   |   8.83   |   83.79   |   96.75   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/hornet/hornet_small_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/hornet/hornet-small_3rdparty_in1k_20220909-fab3bfc3.pth) |
| HorNet-S-GF\* |   50.4    |   8.71   |   83.98   |   96.77   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/hornet/hornet_small_gf_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/hornet/hornet-small-gf_3rdparty_in1k_20220909-cd269a14.pth) |
|  HorNet-B\*   |   87.26   |  15.59   |   84.24   |   96.94   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/hornet/hornet_base_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/hornet/hornet-base_3rdparty_in1k_20220909-41ea3439.pth) |
| HorNet-B-GF\* |   88.42   |  15.42   |   84.32   |   96.95   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/hornet/hornet_base_gf_8xb128_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/hornet/hornet-base-gf_3rdparty_in1k_20220909-759d587c.pth) |
|   EdgeNeXt-Base\*    |   18.51   |   3.84   |   82.48   |   96.2    | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/edgenext/edgenext_base_sz256_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/edgenext/edgenext-base_3rdparty_8xb256_in1k_20220801-9ade408b.pth) |
|   EdgeNeXt-Small\*   |   5.59    |   1.26   |   79.41   |   94.53   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/edgenext/edgenext_base_sz256_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/edgenext/edgenext-small_3rdparty_8xb256_in1k_20220801-d00db5f8.pth) |
|  EdgeNeXt-X-Small\*  |   2.34    |  0.538   |   74.86   |   92.31   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/edgenext/edgenext_base_sz256_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/edgenext/edgenext-xsmall_3rdparty_8xb256_in1k_20220801-974f9fe7.pth) |
| EdgeNeXt-XX-Small\*  |   1.33    |  0.261   |   71.2    |   89.91   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/edgenext/edgenext_base_sz256_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/edgenext/edgenext-xxsmall_3rdparty_8xb256_in1k_20220801-7ca8a81d.pth) |
| EfficientFormer-l1\* |   12.19   |   1.30   |   80.46   |   94.99   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientformer/efficientformer_l1_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientformer/efficientformer-l1_3rdparty_in1k_20220803-d66e61df.pth) |
| EfficientFormer-l3\* |   31.41   |   3.93   |   82.45   |   96.18   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientformer/efficientformer_l3_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientformer/efficientformer-l3_3rdparty_in1k_20220803-dde1c8c5.pth) |
| EfficientFormer-l7\* |   82.23   |  10.16   |   83.40   |   96.60   | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/efficientformer/efficientformer_l7_8xb256_ep300.py) | [model](https://download.openmmlab.com/mmclassification/v0/efficientformer/efficientformer-l7_3rdparty_in1k_20220803-41a552bb.pth) |
| MogaNet-XT | 2.97 | 0.80 | 76.5 | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_xtiny_sz224_8xb128_fp16_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_xtiny_sz224_8xb128_fp16_ep300.pth) / [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_xtiny_sz224_8xb128_fp16_ep300.log.json) |
| MogaNet-XT | 2.97 | 1.04 | 77.2 | - |[config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_xtiny_sz256_8xb128_fp16_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_xtiny_sz256_8xb128_fp16_ep300.pth) / [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_xtiny_sz256_8xb128_fp16_ep300.log.json) |
| MogaNet-XT\* | 2.97 | 1.04 | 77.6 | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_xtiny_deit3_sz256_lr2e_3_8xb128_fp16_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_xtiny_deit3_sz256_lr2e_3_8xb128_fp16_ep300.pth) / [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_xtiny_deit3_sz256_lr2e_3_8xb128_fp16_ep300.log.json) |
| MogaNet-T | 5.20 | 1.10 | 79.0 | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_tiny_sz224_8xb128_fp16_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_tiny_sz224_8xb128_fp16_ep300.pth) / [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_tiny_sz224_8xb128_fp16_ep300.log.json) |
| MogaNet-T | 5.20 | 1.44 | 79.6 | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_tiny_sz256_8xb128_fp16_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_tiny_sz256_8xb128_fp16_ep300.pth) / [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_tiny_sz256_8xb128_fp16_ep300.log.json) |
| MogaNet-T\* | 5.20 | 1.44 | 80.0 | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_tiny_deit3_sz256_lr2e_3_8xb128_fp16_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_tiny_deit3_sz256_lr2e_3_8xb128_fp16_ep300.pth) / [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_tiny_deit3_sz256_lr2e_3_8xb128_fp16_ep300.log.json) |
| MogaNet-S | 25.3 | 4.97 | 83.4 | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_small_ema_sz224_8xb128_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_small_ema_sz224_8xb128_ep300.pth) / [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_small_ema_sz224_8xb128_ep300.log.json) |
| MogaNet-B | 43.9 | 9.93 | 84.2 | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_base_ema_sz224_8xb128_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_base_ema_sz224_8xb128_ep300.pth) / [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_base_ema_sz224_8xb128_ep300.log.json) |
| MogaNet-L | 82.5 | 15.9 | 84.6 | - | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_large_ema_sz224_8xb64_accu2_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_large_ema_sz224_8xb64_accu2_ep300.pth) / [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_large_ema_sz224_8xb64_accu2_ep300.log.json) |


We also provide fast training results using [RSB A3](https://arxiv.org/abs/2110.00476) setting on [ILSVRC 2012](http://www.image-net.org/challenges/LSVRC/2012/). You can download all files from [GitHub](https://github.com/Westlake-AI/openmixup/releases/tag/rsb-a3-weights) / [**Baidu Cloud** (ss3j)](https://pan.baidu.com/s/1WgUn0zOtrmN2GBZ3aFjONw?pwd=ss3j).

| Model | Date | Train / test size | Params(M) | Top-1 (\%) | Top-5 (\%) | Config | Download |
|---|:---:|:---:|:---:|:---:|:---:|:---:|:---:|
| ResNet-50 | CVPR'2016 | 160 / 224 | 26 | 78.1 | 93.8 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/resnet/resnet50_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/resnet50_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/resnet50_rsb_a3_sz160_8xb256_ep100.log.json) |
| ResNet-101 | CVPR'2016 | 160 / 224 | 45 | 79.9 | 94.9 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/resnet/resnet101_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/resnet101_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/resnet101_rsb_a3_sz160_8xb256_ep100.log.json) |
| ResNet-152 | CVPR'2016 | 160 / 224 | 60 | 80.7 | 95.2 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/resnet/resnet152_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/resnet152_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/resnet152_rsb_a3_sz160_8xb256_ep100.log.json) |
| ViT-T | ICLR'2021 | 160 / 224 | 6 | 66.7 | 87.7 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/deit_tiny_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/deit_tiny_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/deit_tiny_rsb_a3_sz160_8xb256_ep100.log.json) |
| ViT-S | ICLR'2021 | 160 / 224 | 22 | 73.8 | 91.2 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/deit_small_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/deit_small_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/deit_small_rsb_a3_sz160_8xb256_ep100.log.json) |
| ViT-B | ICLR'2021 | 160 / 224 | 87 | 76.0 | 91.8 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/deit/deit_base_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/deit_base_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/deit_base_rsb_a3_sz160_8xb256_ep100.log.json) |
| PVT-T | ICCV'2021 | 160 / 224 | 13 | 71.5 | 89.8 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/pvt/pvt_tiny_rsb_a3_sz160_8xb256_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/pvt_tiny_rsb_a3_sz160_8xb256_ep300.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/pvt_tiny_rsb_a3_sz160_8xb256_ep300.log.json) |
| PVT-S | ICCV'2021 | 160 / 224 | 25 | 72.1 | 90.2 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/pvt/pvt_small_rsb_a3_sz160_8xb256_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/pvt_small_rsb_a3_sz160_8xb256_ep300.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/pvt_small_rsb_a3_sz160_8xb256_ep300.log.json) |
| Swin-T | ICCV'2021 | 160 / 224 | 28 | 77.7 | 93.7 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/swin_transformer/swin_tiny_rsb_a3_sz160_8xb256_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/swin_tiny_rsb_a3_sz160_8xb256_ep300.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/swin_tiny_rsb_a3_sz160_8xb256_ep300.log.json) |
| Swin-S | ICCV'2021 | 160 / 224 | 50 | 80.2 | 95.1 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/swin_transformer/swin_small_rsb_a3_sz160_8xb256_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/swin_small_rsb_a3_sz160_8xb256_ep300.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/swin_small_rsb_a3_sz160_8xb256_ep300.log.json) |
| Swin-B | ICCV'2021 | 160 / 224 | 50 | 80.5 | 95.4 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/swin_transformer/swin_base_rsb_a3_sz160_8xb256_ep300.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/swin_base_rsb_a3_sz160_8xb256_ep300.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/swin_base_rsb_a3_sz160_8xb256_ep300.log.json) |
| LITV2-T | NIPS'2022 | 160 / 224 | 28 | 79.7 | 94.7 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/lit_v2/lit_v2_small_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/lit_v2_small_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/lit_v2_small_rsb_a3_sz160_8xb256_ep100.log.json) |
| LITV2-M | NIPS'2022 | 160 / 224 | 49 | 80.5 | 95.2 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/lit_v2/lit_v2_medium_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/lit_v2_medium_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/lit_v2_medium_rsb_a3_sz160_8xb256_ep100.log.json) |
| LITV2-B | NIPS'2022 | 160 / 224 | 87 | 81.3 | 95.5 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/lit_v2/lit_v2_base_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/lit_v2_base_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/lit_v2_base_rsb_a3_sz160_8xb256_ep100.log.json) |
| ConvMixer-768-d32 | arXiv'2022 | 160 / 224 | 21 | 77.6 | 93.5 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convmixer/convmixer_768_d32_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convmixer_768_d32_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convmixer_768_d32_rsb_a3_sz160_8xb256_ep100.log.json) |
| PoolFormer-S12 | CVPR'2022 | 160 / 224 | 12 | 69.3 | 88.7 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_s12_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_s12_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_s12_rsb_a3_sz160_8xb256_ep100.log.json) |
| PoolFormer-S24 | CVPR'2022 | 160 / 224 | 21 | 74.1 | 91.8 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_s24_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_s24_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_s24_rsb_a3_sz160_8xb256_ep100.log.json) |
| PoolFormer-S36 | CVPR'2022 | 160 / 224 | 31 | 74.6 | 92.0 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_s36_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_s36_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_s36_rsb_a3_sz160_8xb256_ep100.log.json) |
| PoolFormer-M36 | CVPR'2022 | 160 / 224 | 56 | 80.7 | 95.2 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_m36_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_m36_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_m36_rsb_a3_sz160_8xb256_ep100.log.json) |
| PoolFormer-M48 | CVPR'2022 | 160 / 224 | 73 | 81.2 | 95.3 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/poolformer/poolformer_m48_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_m48_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/poolformer_m48_rsb_a3_sz160_8xb256_ep100.log.json) |
| ConvNeXt-T | CVPR'2022 | 160 / 224 | 29 | 78.8 | 94.2 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_tiny_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convnext_tiny_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convnext_tiny_rsb_a3_sz160_8xb256_ep100.log.json) |
| ConvNeXt-S | CVPR'2022 | 160 / 224 | 50 | 81.7 | 95.7 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_small_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convnext_small_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convnext_small_rsb_a3_sz160_8xb256_ep100.log.json) |
| ConvNeXt-B | CVPR'2022 | 160 / 224 | 89 | 82.1 | 95.9 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_base_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convnext_base_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convnext_base_rsb_a3_sz160_8xb256_ep100.log.json) |
| ConvNeXt-L | CVPR'2022 | 160 / 224 | 189 | 82.8 | 96.0 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/convnext/convnext_large_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convnext_large_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/convnext_large_rsb_a3_sz160_8xb256_ep100.log.json) |
| VAN-B0 | arXiv'2022 | 160 / 224 | 4 | 72.6 | 94.2 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_tiny_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/van_tiny_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/van_tiny_rsb_a3_sz160_8xb256_ep100.log.json) |
| VAN-B2 | arXiv'2022 | 160 / 224 | 27 | 81.0 | 91.5 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_small_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/van_small_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/van_small_rsb_a3_sz160_8xb256_ep100.log.json) |
| VAN-B3 | arXiv'2022 | 160 / 224 | 45 | 81.9 | 95.7 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/van/van_base_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/van_base_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/van_base_rsb_a3_sz160_8xb256_ep100.log.json) |
| HorNet-T (7×7) | NIPS'2022 | 160 / 224 | 22 | 80.1 | 95.0 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/hornet/hornet_tiny_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/hornet_tiny_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/hornet_tiny_rsb_a3_sz160_8xb256_ep100.log.json) |
| HorNet-S (7×7) | NIPS'2022 | 160 / 224 | 50 | 81.2 | 95.4 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/hornet/hornet_small_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/hornet_small_rsb_a3_sz160_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/rsb-a3-weights/hornet_small_rsb_a3_sz160_8xb256_ep100.log.json) |
| MogaNet-XT | arXiv'2022 | 160 / 224 | 3 | 72.8 | 91.3 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_xtiny_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_xtiny_sz160_rsb_a3_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_xtiny_sz160_rsb_a3_8xb256_ep100.log.json) |
| MogaNet-T | arXiv'2022 | 160 / 224 | 5 | 75.4 | 92.6 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_tiny_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_tiny_sz160_rsb_a3_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_tiny_sz160_rsb_a3_8xb256_ep100.log.json) |
| MogaNet-S | arXiv'2022 | 160 / 224 | 25 | 81.1 | 95.5 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_small_rsb_a3_sz160_8xb256_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_small_sz160_rsb_a3_8xb256_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_small_sz160_rsb_a3_8xb256_ep100.log.json) |
| MogaNet-B | arXiv'2022 | 160 / 224 | 44 | 82.2 | 95.9 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_base_rsb_a3_sz160_8xb128_accu2_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_base_rsb_a3_sz160_8xb128_accu2_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_base_rsb_a3_sz160_8xb128_accu2_ep100.log.json) |
| MogaNet-L | arXiv'2022 | 160 / 224 | 83 | 83.2 | 96.4 | [config](https://github.com/Westlake-AI/openmixup/tree/main/configs/classification/imagenet/moganet/moga_large_rsb_a3_sz160_8xb128_accu2_ep100.py) | [model](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_large_rsb_a3_sz160_8xb128_accu2_ep100.pth) \| [log](https://github.com/Westlake-AI/openmixup/releases/download/moganet-in1k-weights/moga_large_rsb_a3_sz160_8xb128_accu2_ep100.log.json) |
