#!/usr/bin/env python
# coding: utf-8

# In[ ]:

import openai
import numpy as np
import matplotlib.pyplot as plt
from tqdm import tqdm
import GPy
import re
import copy
import math
import concurrent.futures

# This is an auxiliary function to help clean up the response generated by the LLM
# Remove extra dots from the LLM response
def remove_extra_dots(input_string):
    # Split the string at the first occurrence of "."
    first_part, *remaining_parts = input_string.split('.', 1)

    # If there's no "." in the string, return it as is
    if not remaining_parts:
        return input_string

    # Concatenate the first part with the first occurrence of "." and remove extra "." from the remaining parts
    result = first_part + '.' + remaining_parts[0].replace('.', '')

    return result

# Compute cumulative reward after iteration ends
def cumulate_reward(reward):
    reward_copy = copy.deepcopy(reward)
    
    for row in reward_copy:
        for i in range(1, len(row)):
            row[i] += row[i - 1]
    
    return reward_copy

def make_prompt_experiment(X, Y, x_test):
    prompt = "Help me predict the function value at the last input. \
    Each function value is associated with a Normal distribution with a fixed but unknown mean. \
    Your response should only contain the function value in the format of #function value#.\n"
    
    R = 1 - Y  # R is 1 - reward
    
    # Compute the distance between each sample in X and x_test (Euclidean distance)
    # If X is a multi-dimensional array, compute the distance for each sample
    if len(X.shape) > 1:  # Multi-dimensional data (each sample has multiple features)
        X_ = np.linalg.norm(X - x_test, axis=1)  # axis=1 computes Euclidean distance row-wise
    else:  # One-dimensional data (only one feature per sample)
        X_ = np.abs(X - x_test)  # Directly compute absolute difference
    sorted_indices_descending = sorted(range(len(X_)), key=lambda i: X_[i], reverse=True)  # Sort by distance in descending order

    s = ""  # s stores the sorted data
    # for i in np.arange(len(X)):
    for i in sorted_indices_descending:
        s += f"input: {X[i]}, output: {R[i]}\n"
    s += f"input: " + str(x_test) + ", output: "
    prompt += s

    return prompt

