#!/usr/bin/env python
# coding: utf-8

# In[ ]:
import openai
import numpy as np
import matplotlib.pyplot as plt
from tqdm import tqdm
import GPy
import re
import copy
import math
import concurrent.futures

# Linear Bandits
def generate_xx_f_linear(d, K):
    # Randomly generate theta (parameters for the linear relationship)
    theta = np.random.randn(d)  # Sample a d-dimensional vector from a standard normal distribution

    # Randomly generate feature vectors for K arms (Gaussian distribution)
    xx = np.random.randn(K, d)  # K arms, each with a d-dimensional feature vector

    # Compute reward (without noise)
    f = []
    for i in range(K):
        f.append(np.dot(theta, xx[i]))
    
    # Perform Min-Max normalization on xx (column-wise normalization)
    xx_min = xx.min(axis=0) 
    xx_max = xx.max(axis=0) 
    xx = (xx - xx_min) / (xx_max - xx_min)

    # Perform Min-Max normalization on f
    f_min = np.min(f)
    f_max = np.max(f)
    f = (f - f_min) / (f_max - f_min)
    
    return xx, f, theta

# reward = (θ^T x)^2
def generate_xx_f_square(d, K):
    # Randomly generate theta (parameters for the linear relationship)
    theta = np.random.randn(d)  # Sample a d-dimensional vector from a standard normal distribution

    # Randomly generate feature vectors for K arms (Gaussian distribution)
    xx = np.random.randn(K, d)  # K arms, each with a d-dimensional feature vector

    # Compute reward (without noise)
    f = []
    for i in range(K):
        f.append((np.dot(theta, xx[i]))**2)
    
    # Perform Min-Max normalization on xx (column-wise normalization)
    xx_min = xx.min(axis=0) 
    xx_max = xx.max(axis=0) 
    xx = (xx - xx_min) / (xx_max - xx_min)

    # Perform Min-Max normalization on f
    f_min = np.min(f)
    f_max = np.max(f)
    f = (f - f_min) / (f_max - f_min)
    
    return xx, f, theta

# reward = sin(θ^T x)
def generate_xx_f_sin(d, K):
    # Randomly generate theta (parameters for the linear relationship)
    theta = np.random.randn(d)  # Sample a d-dimensional vector from a standard normal distribution

    # Randomly generate feature vectors for K arms (Gaussian distribution)
    xx = np.random.randn(K, d)  # K arms, each with a d-dimensional feature vector

    # Compute reward (without noise)
    f = []
    for i in range(K):
        f.append(math.sin(np.dot(theta, xx[i])))
    
    # Perform Min-Max normalization on xx (column-wise normalization)
    xx_min = xx.min(axis=0) 
    xx_max = xx.max(axis=0) 
    xx = (xx - xx_min) / (xx_max - xx_min)

    # Perform Min-Max normalization on f
    f_min = np.min(f)
    f_max = np.max(f)
    f = (f - f_min) / (f_max - f_min)
    
    return xx, f, theta

# reward = sample from Gaussian Process
def generate_xx_f_GP(d, K):
    # Randomly generate feature vectors for K arms (Gaussian distribution)
    xx = np.random.randn(K, d)  # K arms, each with a d-dimensional feature vector

    # Perform Min-Max normalization on xx (column-wise normalization)
    xx_min = xx.min(axis=0) 
    xx_max = xx.max(axis=0) 
    xx = (xx - xx_min) / (xx_max - xx_min)
    
    kernel = GPy.kern.RBF(input_dim=d, lengthscale=0.4, variance=1)
    # Compute the covariance matrix
    C = kernel.K(xx, xx)
    # Generate a sample from a multivariate normal distribution
    m = np.zeros((C.shape[0]))
    f = np.random.multivariate_normal(m, C, 1).reshape(-1, 1)

    # Perform Min-Max normalization on f
    f_min = np.min(f)
    f_max = np.max(f)
    f = (f - f_min) / (f_max - f_min)
    
    f_list = f.flatten().tolist()
    
    return xx, f_list

