#!/usr/bin/env python
# coding: utf-8

# In[ ]:
import openai
import numpy as np
import matplotlib.pyplot as plt
from tqdm import tqdm
import math
import concurrent.futures
import copy
import GPy

# Define a function to call the ChatGPT API
def get_chatgpt_response(prompt, model="gpt-3.5-turbo", max_tokens=600):
    # response = openai.ChatCompletion.create(
    # response = openai.Completion.create(
    response = openai.chat.completions.create(
        model=model,
        messages=[{"role": "user", "content": prompt}],
        max_tokens=max_tokens,
        temperature=0.1,
    )
    # return response['choices'][0]['message']['content']
    return response

# Define a function to call the ChatGPT API
def get_chatgpt_response_t_large(prompt, model="gpt-3.5-turbo", max_tokens=600):
    # response = openai.ChatCompletion.create(
    # response = openai.Completion.create(
    response = openai.chat.completions.create(
        model=model,
        messages=[{"role": "user", "content": prompt}],
        max_tokens=max_tokens,
        temperature=0.4,
    )
    # return response['choices'][0]['message']['content']
    return response

# Define a function to call the ChatGPT API with variable temperature
def get_chatgpt_response_variable_t(prompt, itr, model="gpt-3.5-turbo", max_tokens=600):
    # response = openai.ChatCompletion.create(
    # response = openai.Completion.create(
    response = openai.chat.completions.create(
        model=model,
        messages=[{"role": "user", "content": prompt}],
        max_tokens=max_tokens,
        temperature = 1.6 - min(0.13*math.sqrt(itr), 1.5)
    )
    # return response['choices'][0]['message']['content']
    return response

# Define a function to call the ChatGPT API with variable temperature
def get_chatgpt_response_variable_t_large(prompt, itr, model="gpt-3.5-turbo", max_tokens=600):
    # response = openai.ChatCompletion.create(
    # response = openai.Completion.create(
    response = openai.chat.completions.create(
        model=model,
        messages=[{"role": "user", "content": prompt}],
        max_tokens=max_tokens,
        temperature = 1.6 - min(0.13*math.sqrt(itr), 1.1)
    )
    # return response['choices'][0]['message']['content']
    return response

