#!/usr/bin/env python
# coding: utf-8

# In[ ]:
import openai
import numpy as np
import matplotlib.pyplot as plt
from tqdm import tqdm
import GPy
import re
import copy
import math
import concurrent.futures

# Optimization iteration function
def optimize_experiment(X, Y, num_iter, xx, f, noise_intensity):

    rewards_all = []
    
    for itr in np.arange(num_iter):
        acq = []  # Acquisition function values
        for j in range(xx.shape[0]):  # This loop updates the acquisition function
            prompt = make_prompt_experiment(X, Y, xx[j, :])

            # response = get_chatgpt_response(prompt, model=gpt_model) # Stable temperature
            response = get_chatgpt_response_variable_t(prompt, itr, model=gpt_model) # Variable temperature
            
            msg = response.choices[0].message.content  # Extract content from the first response of the model
            msg = ''.join(filter(lambda x: x.isdigit() or x == '.', msg))  # Keep only digits and decimal points
            msg = remove_extra_dots(msg)  # Remove extra decimal points
            
            acq.append(np.asarray(msg, dtype=float))  # Convert LLM's predicted results to float and store in the acquisition function list
            
        x_t_idx = np.argmax(acq)  # Select the index of the maximum acquisition value
        x_t = xx[x_t_idx, :]  # Corresponding feature
        y_t = f[x_t_idx] + np.random.normal(0, np.sqrt(noise_intensity))  # Simulate sampling process
        y_t = round(y_t, 4)
    
        rewards_all.append(f[x_t_idx])  # Store the true reward (without noise) of the next sampled point
    
        print("iter: ", itr)
        # print("x_t: ", x_t)
        # print("y_t: ", y_t)
        # print("reward: ", rewards_all[-1])
        X = np.append(X, np.expand_dims(x_t, axis=0), axis=0)
        Y = np.append(Y, y_t)
        
    return rewards_all


def optimize_framingfeature(X, Y, num_iter, xx, f, N_init, noise_intensity, K, colorsheet):

    rewards_all = []
    
    for itr in np.arange(num_iter):
        X_color = mark_color(X, xx, colorsheet)
        prompt = make_prompt_framingfeature(X_color, Y, num_iter, xx, itr, N_init, K, colorsheet)
        response = get_chatgpt_response_zero_t(prompt, model=gpt_model)  # Returns a string containing the probability distribution of the next arm
        msg = response.choices[0].message.content
        
        x_t_idx = dist_response_to_next_arm(msg, K)  # Sample to get the index of the next arm
        x_t = xx[x_t_idx, :]  # Corresponding feature
        y_t = f[x_t_idx] + np.random.normal(0, np.sqrt(noise_intensity))  # Simulate sampling process
        y_t = round(y_t, 4)
    
        rewards_all.append(f[x_t_idx])  # Store the true reward (without noise) of the next sampled point
    
        print("iter: ", itr)
        X = np.append(X, np.expand_dims(x_t, axis=0), axis=0)
        Y = np.append(Y, y_t)
        
    return rewards_all


def optimize_historyfeature(X, Y, num_iter, xx, f, N_init, noise_intensity, K, colorsheet):

    rewards_all = []
    
    for itr in np.arange(num_iter):
        X_color = mark_color(X, xx, colorsheet)
        prompt = make_prompt_historyfeature(X_color, Y, num_iter, xx, itr, N_init, K, colorsheet)
        response = get_chatgpt_response_zero_t(prompt, model=gpt_model)  # Returns a string containing the probability distribution of the next arm
        msg = response.choices[0].message.content
        
        x_t_idx = dist_response_to_next_arm(msg, K)  # Sample to get the index of the next arm
        x_t = xx[x_t_idx, :]  # Corresponding feature
        y_t = f[x_t_idx] + np.random.normal(0, np.sqrt(noise_intensity))  # Simulate sampling process
        y_t = round(y_t, 4)
    
        rewards_all.append(f[x_t_idx])  # Store the true reward (without noise) of the next sampled point
    
        print("iter: ", itr)
        X = np.append(X, np.expand_dims(x_t, axis=0), axis=0)
        Y = np.append(Y, y_t)
        
    return rewards_all


def optimize_nofeature(X, Y, num_iter, xx, f, N_init, noise_intensity, K, colorsheet):

    rewards_all = []
    
    for itr in np.arange(num_iter):
        X_color = mark_color(X, xx, colorsheet)
        prompt = make_prompt_nofeature(X_color, Y, num_iter, itr, N_init, K, colorsheet)
        response = get_chatgpt_response_zero_t(prompt, model=gpt_model)  # Returns a string containing the probability distribution of the next arm
        msg = response.choices[0].message.content
        
        x_t_idx = dist_response_to_next_arm(msg, K)  # Sample to get the index of the next arm
        x_t = xx[x_t_idx, :]  # Corresponding feature
        y_t = f[x_t_idx] + np.random.normal(0, np.sqrt(noise_intensity))  # Simulate sampling process
        y_t = round(y_t, 4)
    
        rewards_all.append(f[x_t_idx])  # Store the true reward (without noise) of the next sampled point
    
        print("iter: ", itr)
        X = np.append(X, np.expand_dims(x_t, axis=0), axis=0)
        Y = np.append(Y, y_t)
        
    return rewards_all


def optimize_randomsearch(num_iter, xx, f, noise_intensity, K):

    rewards_all = []
    
    for itr in np.arange(num_iter):
        
        x_t_idx = np.random.choice(list(range(K)))  # Randomly select the index of the next arm
        x_t = xx[x_t_idx, :]  # Corresponding feature
        y_t = f[x_t_idx] + np.random.normal(0, np.sqrt(noise_intensity))  # Simulate sampling process
        y_t = round(y_t, 4)
    
        rewards_all.append(f[x_t_idx])  # Store the true reward (without noise) of the next sampled point
    
        print("iter: ", itr)
        
    return rewards_all

