# E(*n*)-equivariant Graph Cellular Automata

This repository is the official implementation of E(*n*)-equivariant Graph Cellular Automata.

## Pattern Formation - Convergence to Geometric Graphs

    python train_geometric_graph.py -ds Grid2d -nd 16 -md 32 -s1 15 -s2 25 -sdg 0.05 -rdg 1.0 -bsc 0 8 2000 16 4000 32 -pats 800
    python train_geometric_graph.py -ds Torus  -nd 16 -md 32 -s1 15 -s2 25 -sdg 0.05 -rdg 1.0 -bsc 0 6 1000 8 2000 16 4000 32 -pats 800
    python train_geometric_graph.py -ds Cube   -nd 16 -md 32 -s1 15 -s2 25 -sdg 0.05 -rdg 1.0 -bsc 0 16
    python train_geometric_graph.py -ds Bunny  -nd 16 -md 32 -s1 15 -s2 25 -sdg 0.05 -rdg 1.0 -bsc 0 4 1000 8 2000 16 4000 32

For testing, play with `test_geometric_graph.ipynb`.

## Graph Autoencoding

### E(*n*)-GNCA 3D demo:

    python train_gae.py -ds community   -ne 3000 -cd 3 -nd 16 -md 32 -act tanh -s1 15 -s2 25 -ps 5 -rs 0 5 1000 1000
    python train_gae.py -ds planar      -ne 3000 -cd 3 -nd 16 -md 32 -act tanh -s1 15 -s2 25 -ps 5 -rs 0 5 1000 1000 -ng 200 -n1 12 -n2 20

### E(*n*)-GNCA autoencoder: 

    python train_gae.py -ds community   -ne 3000  -cd 8  -nd 16 -md 32 -act tanh -s1 25 -s2 35 -ps 5 -rs 0 5 1000 1000
    python train_gae.py -ds planar      -ne 3000  -cd 8  -nd 16 -md 32 -act tanh -s1 25 -s2 35 -ps 5 -rs 0 5 1000 1000 -ng 200 -n1 12 -n2 20
    python train_gae.py -ds planar      -ne 3000  -cd 8  -nd 16 -md 32 -act tanh -s1 25 -s2 35 -ps 5 -rs 0 5 1000 1000 -ng 200 -n1 32 -n2 64 -nc 3
    python train_gae.py -ds proteins    -ne 1000  -cd 16 -nd 16 -md 32 -act tanh -s1 25 -s2 35 -ps 5 -rs 0 5 100  1000 -pats 20
    python train_gae.py -ds sbm         -ne 3000  -cd 24 -nd 16 -md 32 -act tanh -s1 25 -s2 35 -ps 5 -rs 0 5 1000 1000

For testing, play with `test_gae.ipynb`.

## Simulation of E(*n*)-equivariant dynamical systems

### Boids

First create the dataset:

    python data/boids.py --n_simulations 500 --n_steps 500 --n_boids 100

then run:

    python train_dsystem.py -ds boids -ne 500 -bs 16 -nd 16 -md 32 -sls 0 20 -lr 1e-3

### NBody

First create the dataset:

    python data/nbody.py --n_simulations 5000 --n_steps 1000 --n_bodies 5

then run:

    python train_dsystem.py -ds nbody -ne 500 -nd 16 -md 32 -sls 0 25

For testing, play with `test_dsystems.ipynb`.
