# Taken from: https://github.com/JXYin24/MCM

import argparse
import os



class BaseOptions():
    def __init__(self):
        self.parser = argparse.ArgumentParser()
        self.initialized = False

    def initialize(self):
        self.parser.add_argument('--data_directory', type=str, default='/home/manhirt/Git/SSSD/data/adbench_seeds_sc_val', required=False, help='path to data')
        self.parser.add_argument('--dataset_seed', type=int, default=0, required=False, help='ADBench dataset seed')
        self.parser.add_argument('--model', type=int, default=9, required=False, help='Specify model')
        self.parser.add_argument('--output_directory', type=str, default='/home/manhirt/Git/MCM/results/ADBench', required=False, help='Output_directory for ckp and results')
        self.initialized = True


    def parse(self):
        if not self.initialized:
            self.initialize()
        self.opt = self.parser.parse_args()


        return self.opt