import argparse
import os

def get_data_paths(directory, seed):
    # List to hold paths of files named 'seed_0'
    import re

    def natural_sort_key(s):
        # Use a regular expression to split the string into numeric and non-numeric parts
        return [int(text) if text.isdigit() else text for text in re.split(r'(\d+)', s)]

    seed_files = []

    # Walk through the directory
    for root, dirs, files in os.walk(directory):
        for name in files:
            if name == f"seed_{seed}.pkl":
                # Construct full file path
                file_path = os.path.join(root, name)
                seed_files.append(file_path)

    return sorted(seed_files, key=natural_sort_key)

class BaseOptions():
    def __init__(self):
        self.parser = argparse.ArgumentParser()
        self.initialized = False

    def initialize(self):
        self.parser.add_argument('--data_directory', type=str, default='/home/manhirt/Git/SSSD/data/adbench_seeds_sc_val', required=False, help='path to data')
        self.parser.add_argument('--dataset_seed', type=int, default=0, required=False, help='ADBench dataset seed')
        self.parser.add_argument('--model', type=int, default=9, required=False, help='Specify model')
        self.parser.add_argument('--output_directory', type=str, default='/home/manhirt/Git/3WNCROD/Code/Results', required=False, help='Output_directory for ckp and results')
        self.initialized = True


    def parse(self):
        if not self.initialized:
            self.initialize()
        self.opt = self.parser.parse_args()


        return self.opt