# Large Pre-Training Datasets Don't Guarantee Robustness after Fine-Tuning

**TL;DR:** We demonstrate that models pretrained on larger datasets can exhibit poorer robustness after fine-tuning compared to models pretrained on smaller datasets when the fine-tuning dataset is small. We analyze this phenomenon using the proposed benchmark.


## Download Dataset
Please refer to the instruction from the each dataset.
* [ImageNet-V2](https://imagenetv2.org/)
* [ImageNet-A](https://github.com/hendrycks/natural-adv-examples)
* [ImageNet-R](https://github.com/hendrycks/imagenet-r)
* [ImageNet-Sketch](https://github.com/HaohanWang/ImageNet-Sketch)
* [ObjectNet-1.0](https://objectnet.dev/download.html)
* [ImageNet-Cartoon & ImageNet-Drawing](https://tiagosalvador.github.io/projects/imagenet-shift/)
* [ImageNet-C](https://github.com/hendrycks/robustness)

## Running
```
python3 main.py  --root  datasets/ --batch_size 64 --epochs 10 \
  --arch $arch --patch_size $patch_size --d_pre $pretrained --model $model \
  --regularization $reg --dataset $dataset --no_split --use_wandb
```


## Acknowledgement
This repository is based on multiple repository including 
* https://github.com/hjbahng/visual_prompting
* https://github.com/huggingface/pytorch-image-models
* https://github.com/microsoft/otdd

