from torch.nn import functional as F


def mse_loss(values, targets):
    loss = sum(F.mse_loss(values[:, i, 0], targets[:, i]) for i in range(values.shape[1]))
    return loss.mean()


def gaussian_nll_loss(values, targets):
    loss = sum(F.gaussian_nll_loss(values[:, i, 0], targets[:, i], F.softplus(values[:, i, -1])) for i in range(values.shape[1]))
    return loss.mean()


def ggd_nll_loss(values, targets):
    beta = F.softplus(values[..., -1])
    loss = sum(((values[:, i, 0] - targets[:, i]).abs() * beta[:, i] - beta[:, i].log() + beta[:, i].pow(-1).lgamma()) * beta[:, i] / beta.sum(dim=-1) for i in range(values.shape[1]))
    return loss.mean()
