import os
import cv2
from tqdm import tqdm
from args import *

def run_scene_detect(args):
    for movie in args.movies:
        print(f'Running {movie}')
        output_dir = args.output_dir
        movie_path = f'{args.movie_path}/{movie}.mp4'
        assert os.path.exists(movie_path), f'Movie path {movie_path} does not exist, please fix!'
        os.system(f'scenedetect --input {movie_path} --output {output_dir} detect-content list-scenes save-images')
        rename_images(output_dir = output_dir, movie_name = movie)
    
def rename_images(movie, output_dir):
    file_nums = []
    for file in os.listdir(output_dir):
        if file[-3:] != 'csv' and file[0] != '.':
            file_num = int(file.split('-')[-2])
            file_nums.append(file_num)
            os.rename(os.path.join(output_dir, file), os.path.join(output_dir, f'{movie}-{file_num}.jpg'))

if __name__ == '__main__':
    args = image_args()
    run_scene_detect(args)