import os
import argparse

def fusion_args():
    ap = argparse.ArgumentParser()

    ap.add_argument('-exp', '--experiment', type = str, required = True, dest = 'exp_name')

    ap.add_argument('-p', '--data_path', action = 'store', type = str, default = 'nlvr-data', dest = 'data_path')
    ap.add_argument('-b', '--batch_size', action = 'store', type = int, default = 32, dest = 'batch_size')
    ap.add_argument('-tm', '--text_model_str', action = 'store', type = str, default = 'princeton-nlp/sup-simcse-bert-base-uncased', dest = 'text_model_str')
    ap.add_argument('-o', '--output_dim', action = 'store', type = int, default = 768, dest = 'output_dim')
    ap.add_argument('-lr', '--learning_rate', action = 'store', type = float, default = 1e-3, dest = 'lr')
    ap.add_argument('-ne', '--num_epochs', action = 'store', type = int, default = 10, dest = 'num_epochs')
    ap.add_argument('-s', '--save_ckpt', action = 'store_true', dest = 'save_ckpt')
    ap.add_argument('-sp', '--save_path', action = 'store', type = str, default = 'fusion-model/experiments')
    ap.set_defaults(save_ckpt = False)

    return ap.parse_args()