# Dead Feature Counts in Sparse Autoencoders Predict Underlying Deep Q Networks' Effectiveness
 To view and interact with the activations of an autoencoder (the simplest and easiest way to interact with this work): `python3 visualize_pacman_autoencoder.py`

 ## To train new models from scratch and interact with them:
 1. To train a DQN from scratch, first run `python3 train_pacman_dqn.py` (hyperparameters can be adjusted; the hyperparameters used in the paper are the default)
 2. Next, train an autoencoder from your trained DQN by editing and running `python3 train_pacman_autoencoder.py` on your new DQN (hyperparameters can be adjusted; the hyperparameters used in the paper are the default)
 3. Pre-generate summary statistics of the autoencoder's activations by editing and running `python3 gen_pacman_feature_activations.py` on your DQN and SAE
 4. View your summary statistics and interact with your model using `python3 visualize_pacman_autoencoder.py`
 5. If you train several models in this way, you can generate your own version of the graph used in the paper's headline result by running `python3 graph_score_features.py` (note that, due to size limitations, only one pretrained DQN and autoencoder is included in this supplemental work section, instead of the full complement of 24 that were used in this research)