import argparse


def parse_args():
    parser = argparse.ArgumentParser(description='ContGru')
    parser.add_argument('--seed', type=int, default=2021,help='Seed - Test your luck!')   
    parser.add_argument('--intensity', type=bool, default=True,help='Intensity')
    parser.add_argument('--model', type=str, default='contgru',help='Model Name')
    parser.add_argument('--h_channels', type=int, default=49,help='Hidden Channels') 
    parser.add_argument('--lr', type=float, default=0.001,help='Learning Rate') 
    parser.add_argument('--weight_decay', type=float, default=0.0001,help='Weight Decay') 
    parser.add_argument('--epoch', type=int, default=100,help='Epoch') 
    parser.add_argument('--solver_method', type=str, default='rk4',help='ODE Solver Methods') 
    parser.add_argument('--alpha', type=float, default=1.0,help='Coeff alpha') 
    parser.add_argument('--beta', type=float, default=0.5,help='Coeff beta') 
    
    #forecasting
    parser.add_argument('--look_window',type=int, default = 20,help='look_window')
    parser.add_argument('--forecast_window',type=int,default=10,help='forecast window')
    parser.add_argument('--stride_window',type=int,default=5,help='stride window')
    parser.add_argument('--dataset',type=str)
    #random missing
    parser.add_argument('--missing_rate',type=float,default=0.3,help='missing rate')
    parser.add_argument('--interpolation',type=str,default='cubic',help='Interpolation Method')
    
    
    
    return parser.parse_args()