import os, sys
import copy
sys.path.append("../")

import dataset.utils.file_handle as io

PREV_PATH = "results"
NEW_PATH = "RESULTS_JSONL"

for path, dir, files in os.walk(PREV_PATH):
    if files:
        for f in files:
            if ".json" in f:
                os.makedirs(
                    os.path.join(
                        NEW_PATH,
                        os.path.sep.join(path.split(os.path.sep)[1:]),
                        ), 
                    exist_ok=True
                    )

                data = io.load_json(os.path.join(path, f))
                results = list(data["results"].values())
                metadata = copy.deepcopy(data)
                del metadata["results"]

                for each in results:
                    each.update(metadata)

                io.save_jsonl(
                    results,              
                    os.path.join(
                        NEW_PATH,
                        os.path.sep.join(path.split(os.path.sep)[1:]),
                        f.replace(".json", ".jsonl")
                    )
                )

    #if os.path.isfile(path):
    #    print(path)