base_root="path to evaluation data"

baseline_name=$1
mp4_path=$2
datapipeoutput=$3

python ./datapipe/stat_mp4_path.py \
    $mp4_path \
    --output $mp4_path/valid_files.txt \
    --frame-threshold 1 --workers 4

bash ./datapipe/datapipe0426-list-eval0509.sh \
    -l $mp4_path/valid_files.txt \
    -o $datapipeoutput \
    -g 8 \
    -p 1

BASE_DIR=$datapipeoutput

# Find all subdirectories
all_dirs=$(find $BASE_DIR -maxdepth 1 -type d -not -path "$BASE_DIR")

if [ -z "$all_dirs" ]; then
    echo "Error: No subdirectories found in $BASE_DIR."
    exit 1
fi

process_directory() {
    local dir="$1"
    local dir_name=$(basename "$dir")
    
    echo "Processing directory: $dir_name"
    
    # Check if masks directory exists
    if [ ! -d "$dir/masks" ]; then
        echo "Warning: masks directory does not exist in $dir_name, skipping this directory."
        return
    fi
    
    # Get all OBJ prefixes
    obj_prefixes=$(ls $dir/masks/OBJ*.png 2>/dev/null | grep -o 'OBJ[0-9][0-9]' | sort -u)
    
    # Check if any OBJ*.png files exist
    if [ -z "$obj_prefixes" ]; then
        echo "Warning: No OBJ*.png files found in directory $dir_name, skipping this directory."
        return
    fi
    
    # Create person directories
    person_num=0
    for prefix in $obj_prefixes; do
        mkdir -p "$dir/masks/person_${person_num}"
        echo "Created person_${person_num} directory for ${prefix}"
        person_num=$((person_num + 1))
    done

    # Process and move files
    person_num=0
    for prefix in $obj_prefixes; do
        for file in $dir/masks/${prefix}_*.png; do
            # Check if file exists
            if [ -f "$file" ]; then
                # Extract base filename
                base_filename=$(basename "$file")
                # Extract 4-digit number from filename
                number=$(echo "$base_filename" | grep -o '[0-9]\{4\}\.png' | sed 's/\.png//')
                
                if [ ! -z "$number" ]; then
                    # Calculate frame number (assuming 10#$number means base 10 conversion)
                    frame_number=$((10#$number))
                    # Copy file with new naming convention
                    cp "$file" "$dir/masks/person_${person_num}/frame_${frame_number}.png"
                else
                    echo "Warning: Unable to extract frame number from file $base_filename."
                fi
            fi
        done
        person_num=$((person_num + 1))
    done
    
    # Clean up original files
    echo "Deleting original image files in directory $dir_name..."
    rm -f $dir/masks/OBJ*.png
    
    echo "Directory $dir_name processing completed!"
    echo "-----------------------------------"
}

# Process all directories
echo "Starting batch processing of subdirectories..."
for dir in $all_dirs; do
    process_directory "$dir"
done

echo "All directories processing completed!"