
export NO_ALBUMENTATIONS_UPDATE=1
export CUDA_VERSION="12.4"
export PATH=/usr/local/cuda-$CUDA_VERSION/bin${PATH:+:${PATH}}
export LIBRARY_PATH=/usr/local/cuda-$CUDA_VERSION/lib64/stubs:$LIBRARY_PATH
export LD_LIBRARY_PATH=/usr/local/cuda-$CUDA_VERSION/lib64${LD_LIBRARY_PATH:+:${LD_LIBRARY_PATH}}
export CUDA_HOME=/usr/local/cuda-$CUDA_VERSION
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/local/cuda-$CUDA_VERSION
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/local/lib/python3.10/site-packages/nvidia/cudnn/lib
export CUDA_LAUNCH_BLOCKING=1
export PYTORCH_CUDA_ALLOC_CONF=expandable_segments:True


finetune_dataset=./tmp

data_path="path to data .txt"



images_num=$(wc -l < "$data_path")


num_gpus=8


num_train_epochs=40
checkpointing_save_num=10
chunks_per_video=64
batch_size=1
gradient_accumulation_steps=1


checkpointing_steps=-1


background_mode="origin"
residual_alpha=0.5
wandbname="danceme-0515-SAfintune52000-frome_swingdance"
ckptpath="path to your save ckpt path/$wandbname"

mkdir -p $ckptpath


face_encoder_finetune_path="path to your pretrain/face_encoder-5496.pth" 
unet_model_finetune_path="path to your pretrain/unet-5496.pth" 
posenet_model_finetune_path="path to your pretrain/pose_net-5496.pth" 


export CUDA_LAUNCH_BLOCKING=1
accelerate launch --main_process_port 29509 \
    train_single.py  \
    --pretrained_model_name_or_path="path to SVD/stable-video-diffusion-img2vid-xt" \
    --output_dir=$ckptpath \
    --data_root_path="$finetune_dataset" \
    --data_path=$data_path \
    --dataset_width=512 \
    --dataset_height=512 \
    --background_mode=$background_mode \
    --num_workers=8 \
    --lr_warmup_steps=500 \
    --sample_n_frames=16 \
    --learning_rate=1e-5 \
    --per_gpu_batch_size=$batch_size \
    --num_train_epochs=$num_train_epochs \
    --mixed_precision="fp16" \
    --gradient_accumulation_steps=$gradient_accumulation_steps \
    --chunks_per_video=$chunks_per_video \
    --checkpointing_steps=$checkpointing_steps \
    --validation_steps=$checkpointing_steps \
    --gradient_checkpointing \
    --checkpoints_total_limit=5000 \
    --resume_from_checkpoint="latest" \
    --wandbname=$wandbname \
    --finetune_mode=True \
    --residual_alpha=$residual_alpha \
    --face_encoder_finetune_path=$face_encoder_finetune_path \
    --unet_model_finetune_path=$unet_model_finetune_path \
    --posenet_model_finetune_path=$posenet_model_finetune_path \
    --num_gpus=$num_gpus \
    --checkpointing_save_num=$checkpointing_save_num \
    > $ckptpath/training_output-$wandbname.log 2>&1


