
## Experiment scripts for genetic programming (GP)

### Setting up the environment

```
conda env create -f environment.yml
conda activate pysr
```

## Experiments
Here are the scripts with the hyperparameters used for each of the three experiments.
You may have to replace the dataset argument (e.g. `../data/boussinesq/boussinesq_1_dt_1e-3.h5`) with the correct path to the generated dataset. 

In general, use the flag `-i` for regressing with invariants (our method), or the flag `-r` for regressing with original variables (baseline).

Use `--seed=-1` to use a random seed (by default, it uses a fixed seed).

Also, use the option `-I` to specify the number of iterations in the GP algorithm.


### Boussinesq 
```bash
# invariants
python3 boussinesq.py ../data/boussinesq/boussinesq_1_dt_1e-3.h5 -i -I 15
# baseline
python3 boussinesq.py ../data/boussinesq/boussinesq_1_dt_1e-3.h5 -r -I 15
```

### Darcy
```bash
# invariants
python3 darcy.py ../data/darcy/darcy.h5 -i -I 200 -p 64 -f 0.1
# baseline
python3 darcy.py ../data/darcy/darcy.h5 -r -I 200 -p 64 -f 0.1
```

### Reaction Diffusion
```bash
# invariants
python3 reac_diff.py ../data/ReacDiff2D/rd_noise0.0005.h5 -i -I 400 -p 64 -f 0.5
# regular
python3 reac_diff.py ../data/ReacDiff2D/rd_noise0.0005.h5 -r -I 400 -p 64 -f 0.5
```

