#!/bin/bash

# Set the cutoff time
END_DATE="20250601_000000"
START_DATE="20250401_000000"

# Path to the parent directory containing all timestamped dirs
PARENT_DIR="./outputs"

for dir in "$PARENT_DIR"/*/; do
    dir_name=$(basename "${dir%/}")
    timestamp=$(echo "$dir_name" | grep -oE '^[0-9]{8}_[0-9]{6}')
    # Check if the timestamp is valid and falls within the specified range
    if [[ -n "$timestamp" && "$timestamp" < "$END_DATE" && "$timestamp" > "$START_DATE" ]]; then
        echo "Removing $dir"
        rm -rf "$dir"
    fi
done