import numpy as np
import sympy as sp


def eval_eq_params(gt, pred, eps=0.05):
    gt, pred = gt.flatten(), pred.flatten()
    gt_nonzero_idx = np.where(np.abs(gt) >= eps)[0]
    pred_nonzero_idx = np.where(np.abs(pred) >= eps)[0]
    gt_nonzero = gt[gt_nonzero_idx]
    pred_nonzero = pred[pred_nonzero_idx]
    success = set(gt_nonzero_idx) == set(pred_nonzero_idx)
    if success:
        rmse = np.sqrt(np.mean((gt_nonzero - pred_nonzero) ** 2)) 
    else:
        rmse = np.inf
    return success, rmse