## Symbolic transformer

We use the [official codebase](https://github.com/facebookresearch/symbolicregression) from [End-to-end symbolic regression with transformers](https://arxiv.org/abs/2204.10532) and their pretrained checkpoint for our experiment. To reproduce the experiment, clone their repository:
```
git clone git@github.com:facebookresearch/symbolicregression.git
```
Download the pretrained model checkpoint from [https://dl.fbaipublicfiles.com/symbolicregression/model1.pt](https://dl.fbaipublicfiles.com/symbolicregression/model1.pt) and put it under `../data`.

Then set up the environment:
```
conda env create -f environment.yml
conda activate deepsr
```

We provide the code for discovering the Boussinesq equation with symbolic transformer. To run the experiment, copy `boussinesq.py` in this directory under the root directory of their repository. Modify the data path on L13 of `boussinesq.py` accordingly. `cd` to the root directory of their repository and run
```
# Using the original variables (baseline)
python boussinesq.py -N 1 -r
# Using the symmetry invariants (our method)
python boussinesq.py -N 1
```

### Reference
Kamienny, P.-A., d’Ascoli, S., Lample, G., and Charton, F. End-to-end symbolic regression with transformers. *Advances in Neural Information Processing Systems*, 35:10269–10281, 2022.