import os
os.environ['NO_PROXY'] = '127.0.0.1,localhost'

import ollama
from langchain_community.embeddings import OllamaEmbeddings
import numpy as np


def reshape_to_128xn(arr):
    """Reshapes an array to (128, n) shape, padding with zeros if necessary."""
    arr = np.array(arr)  # Ensure it's a NumPy array
    length = len(arr)
    
    # Calculate n and pad if necessary
    n = (length + 127) // 128  # Ceiling division to get the next multiple of 128
    padded_length = 128 * n
    if padded_length > length:
        pad_width = padded_length - length
        arr = np.pad(arr, (0, pad_width), 'constant') # Pad with zeros at the end
    return arr.reshape((128, n))


def get_node_attribute_emb(text):
    ollama_emb = OllamaEmbeddings(
        model="llama2",
        base_url="http://localhost:11434"
    )
    emb = ollama_emb.embed_query(text)
    emb = np.array(emb)
    return reshape_to_128xn(emb)

# response = ollama.embeddings(model="llama3", prompt='Llamas are members of the camelid family')
# embedding = response["embedding"]
# print(len(embedding))

# def load_pdf():
#     loader = PyPDFLoader('./.../')

#     pages = loader.load_and_split()
