import pickle
import matplotlib.pyplot as plt
import seaborn as sns
## Load values

params = {
    "axes.labelsize": 14,
    "font.size": 14,
    "legend.fontsize": 14,
    "xtick.labelsize": 14,
    "ytick.labelsize": 14,
    "text.usetex": True,
}
plt.rcParams.update(params)
sns.set_palette("colorblind")
sns.set_style("ticks")


file_names = [
    "results/logistic_T-200000_n-100_bs-1.pickle",
    "results/ridge_T-200000_n-100_bs-1.pickle",
    "results/huber_T-200000_n-100_bs-1.pickle",
    "results/svm_T-200000_n-100_bs-1.pickle",
]

data = []
legends = []

for file_name in file_names:
    with open(file_name, "rb") as f:
        file_data = pickle.load(f)
        data.append(file_data["iterates"])
        data.append(file_data["derivatives"])
        legends.append(file_data["legends"])

fs1, dys1, fs2, dys2, fs3, dys3, fs4, dys4 = data
legends = legends[0]

# cst_alphas
fig, axs = plt.subplots(2, 4, figsize=(12, 4))
# Share y-axis for all subplots in the first row
for ax in axs[0, 1:]:
    ax.sharey(axs[0, 0])
# Share y-axis for all subplots in the second row
for ax in axs[1, 1:]:
    ax.sharey(axs[1, 0])

axs[0, 0].semilogy(fs1)
axs[0, 0].set_ylabel("$f(x) - f(x^\star)$")
axs[0, 0].set_title("Ridge regression")
axs[1, 0].semilogy(dys1)
axs[1, 0].set_ylabel("$\|\partial_\\theta f(x) - \partial_\\theta f(x^\star)\|$")
axs[1, 0].set_xlabel("$k$")

axs[0, 1].semilogy(fs2)
axs[0, 1].set_title("Logistic regression")
axs[1, 1].semilogy(dys2)
axs[1, 1].set_xlabel("$k$")

axs[0, 2].semilogy(fs3)
axs[0, 2].set_title("Huber regression")
axs[1, 2].semilogy(dys3)
axs[1, 2].set_xlabel("$k$")

axs[0, 3].semilogy(fs4)
axs[0, 3].set_title("SVM regression")
axs[1, 3].semilogy(dys4)
axs[1, 3].set_xlabel("$k$")

leg1 = fig.legend(
    legends,
    bbox_to_anchor=(0.5, -0.07),
    loc="lower center",
    ncol=3,
)

plt.tight_layout()
plt.savefig("figures/multiple.pdf", bbox_inches="tight")
plt.show()
