import networkx as nx
from networkx.utils import open_file


@open_file(0, mode='rb')
def read_tve(path):
    encoding = 'utf-8'
    lines = (line.decode(encoding) for line in path)

    create_using = None
    G = nx.empty_graph(0, create_using)

    comments = '#'
    num_nodes, num_edges = None, None
    degrees = {}
    for line in lines:
        p = line.find(comments)
        if p >= 0:
            line = line[:p]
        if not len(line):
            continue
        # split line, should have 2 or more
        s = line.strip().split(' ')
        if len(s) < 3:
            raise ValueError('Wrong format')
        mode = s.pop(0)
        if mode == 't':
            num_nodes = int(s.pop(0))
            num_edges = int(s.pop(0))
        elif mode == 'v':
            u = int(s.pop(0))
            node_label = int(s.pop(0))
            node_degree = int(s.pop(0))
            degrees[u] = node_degree
            G.add_node(u, label=node_label)
        elif mode == 'e':
            u = int(s.pop(0))
            v = int(s.pop(0))
            if len(s) >= 1:
                assert len(s) == 1
                edge_label = int(s.pop(0))
                if edge_label != 0:
                    raise ValueError(f'Edge label != 0 {line} {edge_label}')
            G.add_edge(u, v)
        else:
            raise ValueError(f'Unrecognized line {line}')

    if G.number_of_nodes() != num_nodes:
        raise ValueError(f'Number of nodes {G.number_of_nodes()} != {num_nodes}')
    if G.number_of_edges() != num_edges:
        raise ValueError(f'Number of edges {G.number_of_edges()} != {num_edges}')
    for node in G.nodes():
        if G.degree[node] != degrees[node]:
            raise ValueError(f'Node {node} has degree {G.degree[node]} '
                             f'but file says {degrees[node]}')

    return G


def main():
    # fp = '/home/anonymous/Documents/GraphMatching/model/SubgraphMatching/dataset/youtube/query_graph/query_dense_4_6.graph'
    fp = '/home/anonymous/Documents/GraphMatching/model/SubgraphMatching/dataset/youtube/data_graph/youtube.graph'

    G = read_tve(fp)
    from utils_our import print_g
    print_g(G)

if __name__ == '__main__':
    main()
