#!/bin/bash

# Define the values of k
k_values=(21 31 34 38 40 41 45 55 63 82 103 114)
# k_values=(41 114)

# Iterate through the k values
for k in "${k_values[@]}"
do
    echo "Training with k=$k"
    python train.py --config "configs/dtu_3view.txt" --expname "scan$k" --basedir "log_dtu/test3v" --datadir "../../../rs_dtu_4/DTU/scan$k" --vis_every 20000 --render_only 1 --render_test 0 --render_path 1 --ckpt "log_dtu/test3v/scan$k/scan$k.th"
done

python extra/read_metrics.py --expname "test3v" --log_dir "log_dtu/test3v"