#!/bin/bash

# Set CUDA device
DEVICE=1

# Set root directory
ROOT_DIR="../../../nerf_llff_data"

# Set base directory
BASE_DIR="./log/llff2v_horns"

# Set default config
CONFIG="configs/llff_default_2v.txt"

# Define experiments and their frame IDs
declare -a train_frame_nums=("20 42")
declare -a test_frame_nums=("0 8 16 24 32 40 48 56")

# Run the training scripts
for i in 100; do
    exp="horns" + $i
    train_frame_num="${train_frame_nums[0]]}"
    test_frame_num="${test_frame_nums[0]}"
    echo "Running training for $exp on device $DEVICE"
    CUDA_VISIBLE_DEVICES=$DEVICE python train.py --config $CONFIG --datadir $ROOT_DIR/$exp --expname $exp --train_frame_num $train_frame_num --test_frame_num $test_frame_num --basedir $BASE_DIR
    echo "Training for $exp completed"
done
