#!/bin/bash

# Set CUDA device
DEVICE=0

# Set root directory
ROOT_DIR="../../../nerf_llff_data"

# Set base directory
BASE_DIR="./log/llff3v_horns"

# Set default config
CONFIG="configs/llff_default_3v.txt"

# Define experiments and their frame IDs
declare -a train_frame_nums=("15 30 46")
declare -a test_frame_nums=("0 8 16 24 32 40 48 56")

# Run the training scripts for horns 100 times
for i in {1..100}; do
    exp="horns"
    train_frame_num="${train_frame_nums[0]}"
    test_frame_num="${test_frame_nums[0]}"
    echo "Running training for $exp on device $DEVICE"
    CUDA_VISIBLE_DEVICES=$DEVICE python train.py --config $CONFIG --datadir $ROOT_DIR/$exp --expname $i --train_frame_num $train_frame_num --test_frame_num $test_frame_num --basedir $BASE_DIR
    echo "Training for $exp completed"
done
